package cn.sowjz.search.core.query.response;

import java.util.ArrayList;
import java.util.List;

import cn.sowjz.search.common.VConvert;
import cn.sowjz.search.core.SearchClient;
import cn.sowjz.search.core.db.FieldInfo;

public class WamResponse {

	
	private SearchClient ss;
	int wordnum;
	List<DmkWord> wordlist;	
	int matrix[];
	
	int doc_total;
	int total;
	int doc_num;
	
	byte []databuf;
	public WamResponse(SearchClient ss)
	{
		this.ss=ss;
	}
	
	public int byte2Me(byte[] buf) throws Exception{
		return byte2Me(buf,0);
	}
	public int byte2Me(byte[] buf,int start) throws Exception
	{
		databuf=buf;
		String charset = ss.feedinfo.getCharset();

	
		wordnum = VConvert.bytes2Int(buf, start);
		start += 4;
		
		doc_total = VConvert.bytes2Int(buf, start);
		start += 4;
		total = VConvert.bytes2Int(buf, start);
		start += 4;
		doc_num = VConvert.bytes2Int(buf, start);
		start += 4;
		
		
		wordlist= new ArrayList<DmkWord>();

		String fn = new String(buf, start, 2, charset);
		start += 2;
		FieldInfo info = ss.getSchema().find(fn);
		if (info == null)
			throw new Exception("The field named : " + fn + " is not exist. ");

		for (int i = 0; i < wordnum; i++)
		{
			DmkWord w = new DmkWord();
			start += w.byte2Me(buf, start, info, charset);
			wordlist.add(w);
		}

		int matrixsize=wordnum*(wordnum-1)/2;
		matrix=new int[matrixsize];
		for(int i=0;i<matrixsize;i++)
		{
			matrix[i]= VConvert.bytes2Int(buf, start);
			start += 4;
		}	
		return start;	
	}
	
	public int getMatrixValue(int x,int y)
	{
		if(x==y)return 10000;
		int big=x;
		int small=y;
		if(x<y)
		{
			big=y;
			small=x;
		}	
		int t=0;
		for(int i=0;i<small;i++)
		{
			t+=wordnum-1-i;
		}	
		t+=big-small-1;
		return matrix[t];
	}
	public String toString()
	{
		StringBuffer strb=new StringBuffer();
		strb.append("word cloud: \n");
		strb.append("   doc total=").append(total).append("\n");
		strb.append("   doc num=").append(doc_num).append("\n");
		strb.append("    word number=").append(wordnum).append("\n");
		for(int i=0;i<wordnum;i++)
			strb.append(i).append("\t").append(wordlist.get(i)).append("\n");
		strb.append("\n");
		
		for(int i=0;i<wordnum;i++)
			strb.append("\t").append(wordlist.get(i).getWord());
		strb.append("\n");
		
		for(int i=0;i<wordnum;i++)
		{
			strb.append(wordlist.get(i).getWord());
			for(int j=0;j<wordnum;j++)
				strb.append("\t").append(getMatrixValue(i,j));
			strb.append("\n");
		}	
		return strb.toString();
	}
	public SearchClient getSs() {
		return ss;
	}
	public int getWordnum() {
		return wordnum;
	}
	public List<DmkWord> getWordlist() {
		return wordlist;
	}
	public DmkWord getWord(int no)
	{
		if(no<wordnum)
			return (DmkWord) wordlist.get(no);
		return null;
	}
	
	public int getDocTotal()
	{
		return doc_total;
	}
	public int getDocNum()
	{
		return doc_num;
	}

	public byte[] getDataBuf() {
		
		return databuf;
	}


}
