package cn.sowjz.search.core.query.response;

import java.util.Arrays;

import cn.sowjz.search.common.VConvert;
import cn.sowjz.search.core.SearchClient;
import cn.sowjz.search.core.query.request.QueryRequest;

public class UnitedResponse {

	SearchClient searchSystem;
	public UnitedResponse(SearchClient searchSystem) {
		this.searchSystem=searchSystem;
	}

	
	int data_num;
	int doc_total;
	Object []result;
	int types[];
	private byte[]databuf;
	
	public void bytes2Me(byte[] buf) throws Exception {
		bytes2Me(buf,0);
	}
	public void bytes2Me(byte[] buf,int start) throws Exception {
		databuf=buf;
		data_num = VConvert.bytes2Int(buf, start);
		start += 4;
		doc_total = VConvert.bytes2Int(buf, start);
		start += 4;
		
		result=new Object[data_num];
		types=new int[data_num];
		
		for(int i=0;i<data_num;i++){
			types[i]=VConvert.bytes2Int(buf, start);	start += 4;
			int length=VConvert.bytes2Int(buf, start);	start += 4;
			switch(types[i]){
			case QueryRequest.QUERY_INDEX: 
			case QueryRequest.QUERY_DISTINCT_INDEX: 
			case QueryRequest.QUERY_KEYWORD:	
			case QueryRequest.QUERY_DISTINCT4CTRL:	
				QueryResponse h1=new QueryResponse(searchSystem);
				h1.bytes2Me(buf,start);
				result[i]=h1;
				break;
			case QueryRequest.QUERY_GROUP:
				GroupResponse gh = new GroupResponse(searchSystem);
				gh.byte2Me(buf,start);
				result[i]=gh;
				break;
			case QueryRequest.QUERY_CUBE:
				CubeResponse ch=new CubeResponse(searchSystem);
				ch.byte2Me( buf,start);
				result[i]=ch;
				break;
			case QueryRequest.QUERY_WORDCLOUD:
				WordCloudResponse wch=new WordCloudResponse(searchSystem);
				wch.bytes2Me(buf,start);
				result[i]=wch;
				break;
			case QueryRequest.QUERY_WAM:	
				WamResponse wh=new WamResponse(searchSystem);
				wh.byte2Me(buf,start);
				result[i]=wh;
				break;
			case QueryRequest.QUERY_CLUSTER:
				ClusterResponse clh=new ClusterResponse(searchSystem);
				clh.byte2Me(buf,start);
				result[i]=clh;
				break;
			}
			start+=length;
		}
	}
	@Override
	public String toString() {
		return "UnitedHits [data_num=" + data_num + ", result="
				+ Arrays.toString(result) + "]";
	}

	
	public QueryResponse getOfHits(int n){
		return (QueryResponse) result[n];
	}
	public GroupResponse getOfGroupHits(int n){
		return (GroupResponse) result[n];
	}
	public CubeResponse getOfCubeHits(int n){
		return (CubeResponse) result[n];
	}
	public WordCloudResponse getOfWordCloudHits(int n){
		return (WordCloudResponse) result[n];
	}
	public WamResponse getOfWamHits(int n){
		return (WamResponse) result[n];
	}
	public ClusterResponse getOfClusterHits(int n){
		return (ClusterResponse) result[n];
	}
	
}
