package cn.sowjz.search.core.query.response;

import java.util.ArrayList;
import java.util.List;

import cn.sowjz.search.common.VConvert;
import cn.sowjz.search.core.SearchClient;
import cn.sowjz.search.core.db.Schema;
import cn.sowjz.search.core.query.request.QueryRequest;

public class SummaryResponse {

	SearchClient ss;
	QueryRequest requ;
	
	
	private int total; // 能够查到的总数
	private int gnum; // 这次返回的总数
	private int doc_num;
	private int doc_total;
	private byte[]databuf;
	
	private int sentence_num;
	
	List<SummHit> summHits;
	
	public SummaryResponse(SearchClient searchSystem, QueryRequest req) {
		this.ss=searchSystem;
		this.requ=req;
	}

	
	public SearchClient getSs() {
		return ss;
	}

	public QueryRequest getQueryRequest() {
		return requ;
	}



	public int getDocNum() {
		return doc_num;
	}

	public int getDocTotal() {
		return doc_total;
	}

	public byte[] getDatabuf() {
		return databuf;
	}

	public List<SummHit> getSummHits() {
		return summHits;
	}
	public int getSentenceNum(){
		return sentence_num;
	}

	public class SummHit{
		String sentence;
		Hit hit;
		int i1;
		int i2;
		
		public Hit getHit() {
			return hit;
		}

		public String getSentence() {
			return sentence;
		}

		@Override
		public String toString() {
			return "SummHit [sentence=" + sentence + ", hit=" + hit + "]";
		}
	
	}
	
	public SummaryResponse bytes2Me(byte[] buf) throws Exception {
		databuf=buf;
		
		Schema schema = ss.getSchema();
		String charset = ss.feedinfo.getCharset();

		int i = 0;
		int num=(VConvert.bytes2Int(buf, i));
		i += 4;
		doc_num=(VConvert.bytes2Int(buf, i));
		i += 4;
		gnum=(VConvert.bytes2Int(buf, i));
		i += 4;
		total=(VConvert.bytes2Int(buf, i));
		i += 4;
		doc_total=(VConvert.bytes2Int(buf, i));
		i += 4;
		summHits = new ArrayList<SummHit>(num);
		Hit lasthit=null;
		for (int j = 0; j < num; j++)
		{
			SummHit summHit = new SummHit();
			
			int len = VConvert.bytes2Int(buf, i);
			i += 4;
			summHit.sentence= new String(buf, i, len - 1, charset);
			i += len;
			
			summHit.i1=(VConvert.bytes2Int(buf, i));
			i += 4;
			summHit.i2=(VConvert.bytes2Int(buf, i));
			i += 4;
			
			byte b=buf[i++];
			if(b==0)
				summHit.hit=lasthit;
			else
			{
				lasthit=new Hit(ss);
				i += lasthit.bytes2Me(buf, i, schema, charset);
				summHit.hit=lasthit;
			}	
			summHits.add(summHit);		
		}
		sentence_num=num;
		return this;
		
	}

	@Override
	public String toString() {
		return "SummaryHits [total=" + total + ", gnum=" + gnum + ", unum="
				+ doc_num + ", grandtotal=" + doc_total + ", summHit=" + summHits + "]";
	}

}
