package cn.sowjz.search.core.query.response;

import java.util.List;

import cn.sowjz.search.common.VConvert;
import cn.sowjz.search.common.htmlparse.IHtml2Txt;
import cn.sowjz.search.core.SearchClient;
import cn.sowjz.search.core.db.FieldInfo;
import cn.sowjz.search.core.db.Schema;
import cn.sowjz.search.core.doc.Doc;
import cn.sowjz.search.core.query.highlight.HighLight;

public class Hit
{
	SearchClient client = null;


	protected long time;

	protected int segid;

	protected int docid;

	protected int weight;

	protected long id;

	protected double heat;
	
	protected Doc doc;
	
	int doclen;
	

	BaseResponse hits;
	
	public Hit(SearchClient sc,BaseResponse hits)
	{
		doc = new Doc(sc);
		this.client = sc;
		this.hits=hits;
	}
	public Hit(SearchClient sc)
	{
		doc = new Doc(sc);
		this.client = sc;
	}

	/**
	 * @return Returns the docid.
	 */
	public int getDocid()
	{
		return docid;
	}

	/**
	 * @return Returns the segid.
	 */
	public int getSegid()
	{
		return segid;
	}

	/**
	 * @return Returns the time.
	 */
	public long getTime()
	{
		return time;
	}
    public Doc getDoc()
    {
    	return doc;
    }
	/**
	 * @return Returns the weight.
	 */
	public int getWeight()
	{
		return weight;
	}

	public String[] getFieldnames()
	{
		return doc.getFieldnames();
	}

	public String stringValue(String fieldName)
	{
		return doc.getAsString(fieldName);
	}

	public int intValue(String fieldName)
	{
		return doc.getAsint(fieldName);
	}

	public long longValue(String fieldName)
	{
		return doc.getAslong(fieldName);
	}
	public byte[]getByteArray(String fieldName)
	{
	
		return doc.getAsbyteArray(fieldName);
	}
	public String getByteArrayOfHexStr(String fieldName)
	{
		
		
		return doc.getAsByteArrayOfHexStr(fieldName);
	}

	public String getSummary(String fieldname, String keyStr, String startMark, String endMark, int reltLen)
	{
		FieldInfo info = client.getSchema().find(fieldname);
		if (null == info)
			throw new IllegalArgumentException("no field named : " + fieldname);
		if (!info.isCateField() && !info.isTextField()&&!info.isVarcharField())
			throw new IllegalArgumentException("should be category field or text field, but field named : " + fieldname + " is not.");

		String v = this.stringValue(fieldname);

		if((info.isArticleField()||info.getType()==FieldInfo.TYPE_TEXT)&& (info.getFlag() &2)!=0)
		{
			v=IHtml2Txt.parse(v);
		}
		
		
		return new HighLight().highLight(v, keyStr, startMark, endMark, reltLen);
	}
	public String getSummary4fuzzy(String fieldname, String keyStr, String startMark, String endMark, int reltLen)
	{
		FieldInfo info = client.getSchema().find(fieldname);
		if (null == info)
			throw new IllegalArgumentException("no field named : " + fieldname);
		if (!info.isCateField() && !info.isTextField()&&!info.isVarcharField())
			throw new IllegalArgumentException("should be category field or text field, but field named : " + fieldname + " is not.");

		String v = this.stringValue(fieldname);

		if((info.isArticleField()||info.getType()==FieldInfo.TYPE_TEXT)&& (info.getFlag() &2)!=0)
		{
			v=IHtml2Txt.parse(v);
		}
			
			try {
				List<XWord> ws=hits.tokenSearchOpKey(keyStr);
				if(ws!=null && ws.size()>0)
				  return new HighLight().highLight4fuzzy(v, ws, startMark, endMark, reltLen);
			} catch (Exception e) {
				e.printStackTrace();
			}
			
			
		
		return null;
	}

	
	/**
	 * 设置字段的内容。如果该字段已经有内容，新的内容会覆盖原始内容
	 * @param fieldname -- 字段名
	 * @param value -- 字段内容
	 */
	public void setValue(String fieldname, String value)
	{
		doc.setValue(fieldname, value);
	}

	/**
	 * 设置字段的内容。如果该字段已经有内容，新的内容会覆盖原始内容
	 * @param fieldname -- 字段名
	 * @param value -- 字段内容
	 */
	public void setValue(String fieldname, long value)
	{
		doc.setValue(fieldname, value);
	}

	/**
	 * 设置字段的内容。如果该字段已经有内容，新的内容会覆盖原始内容
	 * @param fieldname -- 字段名
	 * @param value -- 字段内容
	 */
	public void setValue(String fieldname, int value)
	{
		doc.setValue(fieldname, value);
	}

	public int bytes2Me(byte[] buf, int start, Schema schema, String charset) throws Exception
	{
		int start_bak = start;
		// --------------------------------------------
		this.time = VConvert.bytes2Long(buf, start);
		start += 8;
		// this.segid = Convert.bytes2Int(buf, start);
		// start += 4;
		// this.docid = Convert.bytes2Int(buf, start);
		// start += 4;
		this.weight = VConvert.bytes2Int(buf, start);
		start += 4;
		this.heat = VConvert.bytes2double(buf, start);
		start += 8;
		
		
		start += 4;
		// --------------------------------------------
	
		start += 8;
		
		int len = VConvert.bytes2Int(buf, start);
		start += 4;
		doclen=len;
		int al=doc.fillIn(buf,start,len);
       
		FieldInfo fi=schema.getSeqFI();
		if(fi!=null)
		
	    id=doc.getAslong(fi.getName());
		return start - start_bak+al;
	}



	/**
	 * (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString()
	{
		StringBuffer buf = new StringBuffer(64);
		buf.append("[time=").append(time).append(", id=").append(id).append(", segid=").append(segid).append(", docid=").append(docid).append(", weight=")
				.append(weight).append(", heat=")
				.append(heat).append('\n');
		buf.append(doc);
		buf.append("]");

		return buf.toString();
	}

	public long getId()
	{
		return id;
	}




	public int getDoclen()
	{
		return doclen;
	}
	

	
	public double getHeat(){
		return heat;
	}

	
}