package cn.sowjz.search.core.query.response;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import cn.sowjz.search.common.VConvert;
import cn.sowjz.search.core.SearchClient;
import cn.sowjz.search.core.db.FieldInfo;

public class GroupResponse extends BaseResponse
{
    int docTotal;
    int groupTotal;
	private List<GroupHit> hits;

	byte [] databuf;
	
	public GroupResponse(SearchClient sc)
	{
		super(sc);
		hits = new LinkedList<GroupHit>();
	}

	
	public void sort(Comparator<GroupHit> comp)
	{
		Collections.sort(this.hits, comp);
	}

	@Override
	public String toString()
	{
		StringBuffer strb = new StringBuffer();
		strb.append("total doc:").append(docTotal);
		strb.append(" total group:").append(groupTotal)
		.append(" sum field num:").append(sumFieldNum).append("\n");
		for (GroupHit hit : hits)
			strb.append(hit).append("\n");
		return strb.toString();
	}

	public GroupHit get(int i)
	{
		return hits.get(i);
	}

	public int size()
	{
		return hits.size();
	}

	public Iterator<GroupHit> iterator()
	{
		return hits.iterator();
	}

	public void add(GroupHit ghit)
	{
		hits.add(ghit);
	}
	public void sortByKey()
	{
	  
		Collections.sort(hits,new GroupHitByKeyComparator()); 
	}
	public void sortByValue()
	{
	  
		Collections.sort(hits,new GroupHitByNumComparator()); 
	}
	public int getDocTotal()
	{
		return docTotal;
	}
    public int getTotalOfGroup()
    {
    	return groupTotal;
    }
	public byte[] getDataBuf() 
	{
		
		return  databuf; 
	}

	int sumFieldNum;
	
	
	public int byte2Me( byte[] buf) throws Exception{
		
			return byte2Me(buf,0);
	}
	

	public int byte2Me(byte[] buf, int start) throws Exception {	
		databuf=buf;
		
		
		int start_bak = start;

		int size = VConvert.bytes2Int(buf, start);
		start += 4;
		groupTotal = VConvert.bytes2Int(buf, start);
		start += 4;
		docTotal = VConvert.bytes2Int(buf, start);
		start += 4;
		if (hits == null)
			hits = new LinkedList<GroupHit>();
		
		
		String fn = new String(buf, start, 2, client.feedinfo.getCharset());
		start += 2;
		FieldInfo info = client.getSchema().find(fn);
		if (info == null)
			throw new Exception("The field named : " + fn + " is not exist. ");

		
		
			sumFieldNum= VConvert.bytes2Int(buf, start);
			start += 4;
		
	
		
		for (int i = 0; i < size; i++)
		{
			GroupHit hit = new GroupHit();
			start += hit.byte2Me(buf, start, info, client.feedinfo.getCharset(),client.getSpecialIdxParser());
			if(sumFieldNum>0)
				start += hit.byte2SumValues(buf, start, sumFieldNum);
			hits.add(hit);
		}
		
		
		//sort(new GroupHitByNumComparator());
		return start - start_bak;
		
	}

	public int getSumFieldNum() {
		return sumFieldNum;
	}
	

}
