package cn.sowjz.search.core.query.response;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;

import cn.sowjz.search.common.VConvert;
import cn.sowjz.search.core.conf.SpecialIdxParser;
import cn.sowjz.search.core.db.FieldInfo;

public class GroupHit
{
	protected String key;

	int num;

	public GroupHit()
	{
	}

	public GroupHit(String key, int num)
	{
		this.key = key;
		this.num = num;
	}

	public int byte2Me(byte[] buf, int start, FieldInfo info, String charset, SpecialIdxParser sParser) throws UnsupportedEncodingException
	{
		int start_bak = start;
		if (info.isIntField())
		{
			String key = sParser.getEnumName(info.getName(),VConvert.bytes2Int(buf, start));
			start += 4;
			int num = VConvert.bytes2Int(buf, start);
			start += 4;
			this.setKey(key);
			this.setNum(num);
		} else if (info.isInt64Field())
		{
			String key = String.valueOf(VConvert.bytes2Long(buf, start)).trim();
			start += 8;
			int num = VConvert.bytes2Int(buf, start);
			start += 4;
			this.setKey(key);
			this.setNum(num);
		} else if (info.isBitField())
		{
			String key = sParser.getEnumName(info.getName(),buf[ start]);
			start += 1;
			int num = VConvert.bytes2Int(buf, start);
			start += 4;
			this.setKey(key);
			this.setNum(num);
		} 
		else
		{
			int len = VConvert.bytes2Int(buf, start);
			start += 4;
			String key = new String(buf, start, len - 1, charset);
			start += len;
			len = VConvert.bytes2Int(buf, start);
			start += 4;
			this.setKey(key);
			this.setNum(len);
		}
		return start - start_bak;
	}

	long [] sumValues;
	public int byte2SumValues(byte[] buf, int start,int num){
		
		int start_bak = start;
		sumValues =new long[num];
		for(int i=0;i<num;i++){
			sumValues[i]=VConvert.bytes2Long(buf, start);
			start += 8;
		}
		return start - start_bak;
	}
			
	
	public long[] getSumValues() {
		return sumValues;
	}

	public String toString()
	{
		
		return this.key + " : " + this.num +(sumValues!=null?Arrays.toString(sumValues):"");
	}

	/**
	 * @return Returns the key.
	 */
	public String getKey()
	{
		return key;
	}

	/**
	 * @param key The key to set.
	 */
	public void setKey(String key)
	{
		this.key = key;
	}

	/**
	 * @return Returns the num.
	 */
	public int getNum()
	{
		return num;
	}

	/**
	 * @param num The num to set.
	 */
	public void setNum(int num)
	{
		this.num = num;
	}
}
