package cn.sowjz.search.core.query.response;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

import cn.sowjz.search.common.VConvert;

public class DocIDAndTimeResultSet
{
	private int total;

	private Map<Long, Long> map = new LinkedHashMap<Long, Long>();

	/**
	 * 得到一共可以检索的数量
	 * @return
	 */
	public int getTotal()
	{
		return total;
	}

	/**
	 * 得到返回的数量
	 * @return
	 */
	public int getSize()
	{
		return map.size();
	}

	/**
	 * 得到所有的ID
	 * @return
	 */
	public Set<Long> getDocIds()
	{
		return map.keySet();
	}

	/**
	 * 返回毫秒数
	 * @param docid
	 * @return
	 */
	public long getTime(long docid)
	{
		return map.get(docid);
	}

	public int bytes2Me(byte[] buf, int start)
	{
		int start_bak = start;

		total = VConvert.bytes2Int(buf, start_bak);
		start_bak += 4;
		int size = VConvert.bytes2Int(buf, start_bak);
		start_bak += 4;

		for (int i = 0; i < size; i++)
		{
			this.map.put(VConvert.bytes2Long(buf, start_bak), VConvert.bytes2Long(buf, start_bak + 8));
			start_bak += 16;
		}

		return start_bak - start;
	}

	@Override
	public String toString()
	{
		StringBuffer strb = new StringBuffer();
		Set<Long> ids = map.keySet();
		strb.append("总数 = ").append(total).append(" 返回数量 = ").append(this.getSize()).append("\n");
		for (Iterator<Long> iter = ids.iterator(); iter.hasNext();)
		{
			long id = iter.next();
			strb.append("id:").append(id).append("===>").append("time:").append(map.get(id)).append("\n");
		}

		return strb.toString();
	}
}
