package cn.sowjz.search.core.query.response;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import cn.sowjz.search.common.VConvert;
import cn.sowjz.search.core.SearchClient;
import cn.sowjz.search.core.db.Schema;

public class DistinctResponse extends BaseResponse
{
	private int distincted_doc_total; // 能够查到的总数

	private int distincted_doc_num; // 这次返回的总数
	private int doc_num;
	
	private int doc_total;

	List<DistinctHit> hits;
	private byte[]databuf;


	public DistinctResponse(SearchClient sc)
	{
		super( sc);
		hits = new ArrayList<DistinctHit>(6);
	}
	

	public void addHit(DistinctHit hit)
	{
		hits.add(hit);
	}

	public void removeHit(DistinctHit hit)
	{
		hits.remove(hit);
	}


	/**
	 * @return the num, it's not a real size
	 */
	public int getDistinctedDocNum()
	{
		return distincted_doc_num;
	}

	/**
	 * @return Returns the total.
	 */
	public int getDistinctedDocTotal()
	{
		return distincted_doc_total;
	}

	

	public DistinctHit get(int i)
	{
		if (hits.size() <= 0 || i < 0 || i >= hits.size())
			return null;
		return hits.get(i);
	}

	/**
	 * @param hits The hits to set.
	 */
	public void setHits(List<DistinctHit> hits)
	{
		this.hits = hits;
	}

	/**
	 * convert a byte array to Hits class
	 * @param buf
	 * @return
	 * @throws IOException
	 * @throws
	 * @throws Exception
	 */
	public DistinctResponse bytes2Me(byte[] buf) throws Exception{
		return bytes2Me(buf,0);
	}
	public DistinctResponse bytes2Me(byte[] buf,int i) throws Exception
	{
		databuf=buf;
		
		Schema schema = client.getSchema();
		String charset = client.feedinfo.getCharset();

		
		doc_num=(VConvert.bytes2Int(buf, i));
		i += 4;
		distincted_doc_num=(VConvert.bytes2Int(buf, i));
		i += 4;
		distincted_doc_total=(VConvert.bytes2Int(buf, i));
		i += 4;
		doc_total=(VConvert.bytes2Int(buf, i));
		i += 4;
		hits = new ArrayList<DistinctHit>(this.distincted_doc_num);
		DistinctHit lasthit=null;
		for (int j = 0; j < this.doc_num; j++)
		{
			

			if(j>0 && VConvert.bytes2Int(buf, i+20) ==0){
				Hit hit = new Hit(client,this);

				i += hit.bytes2Me(buf, i, schema, charset);
				lasthit.addToCopies(hit);
			}else
			{ 
				DistinctHit hit = new DistinctHit(client,this);

				i += hit.bytes2Me(buf, i, schema, charset);
				
				hits.add(hit);
			   lasthit=hit;
			}   
		}
		return this;
	}



	@Override
	public String toString()
	{
		StringBuffer strb = new StringBuffer();
		strb.append("不重复记录: ").append(getDistinctedDocTotal()).append("条,");
		strb.append("一共查到记录: ").append(getDoctotal()).append("条,");
		strb.append("此次返回记录：").append(distincted_doc_num).append("条\n");
		for (int i = 0; i < hits.size(); i++)
		{
			strb.append("Hit-").append(i).append(": ").append(get(i).toString()).append("\n");
		}
		return strb.toString();
	}

	public Iterator<DistinctHit> iterator()
	{
		return hits.iterator();
	}

	public int getDoctotal() {
		return doc_total;
	}


	public byte[] getDataBuf()
	{
		return databuf;
	}


	
}
