package cn.sowjz.search.core.query.response;

import java.util.ArrayList;
import java.util.List;

import cn.sowjz.search.common.VConvert;
import cn.sowjz.search.core.SearchClient;
import cn.sowjz.search.core.db.FieldInfo;
import cn.sowjz.search.core.db.Schema;

public class DistinctHit extends Hit{
	

	int copyNum = 0;


	protected double groupheat;
	

	
	private List<Hit> copies;


	
	public DistinctHit(SearchClient sc,DistinctResponse resp)
	{
		super(sc,resp);
	
	}
	public DistinctHit(SearchClient sc)
	{
		super(sc);
	}




	@Override
	public int bytes2Me(byte[] buf, int start, Schema schema, String charset) throws Exception
	{
		int start_bak = start;
		// --------------------------------------------
		this.time = VConvert.bytes2Long(buf, start);
		start += 8;
		// this.segid = Convert.bytes2Int(buf, start);
		// start += 4;
		// this.docid = Convert.bytes2Int(buf, start);
		// start += 4;
		this.weight = VConvert.bytes2Int(buf, start);
		start += 4;
		this.heat = VConvert.bytes2double(buf, start);
		start += 8;
		
		this.copyNum = VConvert.bytes2Int(buf, start);
		start += 4;
		// --------------------------------------------
		this.groupheat = VConvert.bytes2double(buf, start);
		start += 8;
		
		int len = VConvert.bytes2Int(buf, start);
		start += 4;
		doclen=len;
		int al=doc.fillIn(buf,start,len);
       
		FieldInfo fi=schema.getSeqFI();
		if(fi!=null)
		
	    id=doc.getAslong(fi.getName());
		return start - start_bak+al;
	}



	/**
	 * (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString()
	{
		StringBuffer buf = new StringBuffer(64);
		buf.append("[time=").append(time).append(", id=").append(id).append(", segid=").append(segid).append(", docid=").append(docid).append(", weight=")
				.append(weight).append(", heat=")
				.append(heat).append(", allCopyNum=").append(copyNum).append(", group_heat=")
				.append(groupheat).append('\n');
		buf.append(doc);
		buf.append("]");

		return buf.toString();
	}


	public int getTotalDupNum()
	{
		return copyNum;
	}



	
	public void addToCopies(Hit h)
	{
		if(copies==null)
			copies=new ArrayList<Hit>();
		copies.add(h);
	}
	public List<Hit> getDupList()
	{
		return copies;
	}
    public int getDupNum()
    {
    	if(copies==null)return 0;
    	return copies.size();
    }

	
	
	public double getGroupHeat(){
		return groupheat;
	}
}
