package cn.sowjz.search.core.query.response;

import java.util.ArrayList;
import java.util.List;

import cn.sowjz.search.common.VConvert;

public class DbSeqScope {

	int num;
	List<SeqScope> scopes;
	public void bytes2Me(byte[] buf) {
		
		int start=0;
		num = VConvert.bytes2Int(buf, start);
		start += 4;
		
		scopes=new ArrayList<SeqScope>();
		for(int i=0;i<num;i++)
		{
			SeqScope ss=new SeqScope();
			start+=ss.bytes2Me(buf,start);
			scopes.add(ss);
		}	
		
	}

	public class SeqScope{
		public int run_ok;
		public int host_sn;
		public long min;
		public long max;
		public int bytes2Me(byte[] buf, int begin) {
			int start=begin;
			run_ok = VConvert.bytes2Int(buf, start);
			start += 4;
			host_sn = VConvert.bytes2Int(buf, start);
			start += 4;
			min = VConvert.bytes2Long(buf, start);
			start += 8;
			max = VConvert.bytes2Long(buf, start);
			start += 8;
			return start-begin;
		}
		@Override
		public String toString() {
			return "SeqScope [run_ok=" + run_ok + ", host_sn=" + host_sn
					+ ", min=" + min + ", max=" + max + "]";
		}
		
	}

	public int getNum() {
		return num;
	}

	public List<SeqScope> getScopes() {
		return scopes;
	}

	public SeqScope getScope(int i){
		return scopes.get(i);
	}
	@Override
	public String toString() {
		return "DbSeqScope [num=" + num + ", scopes=" + scopes + "]";
	}
	
	public void checkDupHostSN() throws Exception{
		if(num<2)
			return ;
		for(int i=1;i<num;i++)
		{	int sni=scopes.get(i).host_sn;
			for(int j=0;j<i;j++)
			{
				if(scopes.get(j).host_sn==sni)
					throw new Exception("host_sn("+sni+") duped!");
			}
		}
	}
}
