package cn.sowjz.search.core.query.response;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import cn.sowjz.search.common.VConvert;
import cn.sowjz.search.core.SearchClient;
import cn.sowjz.search.core.db.FieldInfo;

public class CubeResponse extends BaseResponse{

	private List<CubeHit> hits;

	List<GroupHit> g2hits;
	int docTotal;
	int groupTotal;
	int cubeTotal;
	int sumFieldNum;
	public CubeResponse(SearchClient sc)
	{
		super( sc);
		hits = new LinkedList<CubeHit>();
	}

	byte [] databuf;
	

	
	public int byte2Me(byte[] buf) throws Exception{
		return byte2Me(buf,0);
	}
	public int byte2Me(byte[] buf,int start) throws Exception
	{
		databuf=buf;
		
		int start_bak = start;

		int size = VConvert.bytes2Int(buf, start);
		start += 4;
		cubeTotal=VConvert.bytes2Int(buf, start);
		start += 4;
		docTotal=VConvert.bytes2Int(buf, start);
		start += 4;
		
		
		
		
		if (hits == null)
			hits = new LinkedList<CubeHit>();
		

		
		String fn1 = new String(buf, start, 2, client.feedinfo.getCharset());
		start += 2;
		FieldInfo info1 = client.getSchema().find(fn1);
		if (info1 == null)
			throw new Exception("The field named : " + fn1 + " is not exist. ");

		String fn2 = new String(buf, start, 2, client.feedinfo.getCharset());
		start += 2;
		FieldInfo info2 = client.getSchema().find(fn2);
		if (info2 == null)
			throw new Exception("The field named : " + fn2 + " is not exist. ");
		
		
			sumFieldNum=VConvert.bytes2Int(buf, start);
			start += 4;
		
		for (int i = 0; i < size; i++)
		{
			CubeHit hit = new CubeHit();
			start += hit.byte2Me(buf, start, info1, info2,client.feedinfo.getCharset(),client.getSpecialIdxParser(),sumFieldNum);
			hits.add(hit);
		}
		int size2 = VConvert.bytes2Int(buf, start);
		start += 4;
		groupTotal= VConvert.bytes2Int(buf, start);
		start += 4;
		g2hits=new ArrayList<GroupHit>(size2);
		for (int i = 0; i < size2; i++)
		{
			GroupHit hit = new GroupHit();
			start += hit.byte2Me(buf, start, info2, client.feedinfo.getCharset(),client.getSpecialIdxParser());
			if(sumFieldNum>0)
				start += hit.byte2SumValues(buf, start, sumFieldNum);
			g2hits.add(hit);
		}
		//sort(new GroupHitByNumComparator());
		return start - start_bak;
	}

	public void sort(Comparator<CubeHit> comp)
	{
		Collections.sort(this.hits, comp);
	}

	@Override
	public String toString()
	{
		StringBuffer strb = new StringBuffer();
		strb.append("record =").append(hits.size());
		strb.append("Total record =").append(getTotalOf1stFiled()).append(" total doc=").append(docTotal).append("\n");
		for (CubeHit hit : hits)
			strb.append(hit).append("\n");
		strb.append("\nsecond field group result:(total=");
	
	strb.append(this.getTotalOf2stField());
		strb.append(")\n");
		for (GroupHit hit : g2hits)
			strb.append(hit).append("\n");
		return strb.toString();
	}

	public CubeHit get(int i)
	{
		return hits.get(i);
	}

	public int size()
	{
		return hits.size();
	}

	public Iterator<CubeHit> iterator()
	{
		return hits.iterator();
	}


	public void sortByKey()
	{
	  
		Collections.sort(hits,new GroupHitByKeyComparator()); 
		sortSubByValue();
	}
	public void sortByValue()
	{
	  
		Collections.sort(hits,new GroupHitByNumComparator());
		sortSubByValue();
	}
	public void sortSubByKey()
	{
		if(hits!=null)
			for(int i=0;i<hits.size();i++)
			{
				CubeHit ch=hits.get(i);
				ch.sortByKey();
			}	
	  
	
	}
	public void sortSubByValue()
	{
		if(hits!=null)
			for(int i=0;i<hits.size();i++)
			{
				CubeHit ch=hits.get(i);
				ch.sortByValue();
			}	
	}
	public int getDocTotal()
	{
		return docTotal;
	}
	public int getTotalOf1stFiled()
	{
		return cubeTotal;
	}
	public int getTotalOf2stField()
	{
		return groupTotal;
	}
	public List<GroupHit> getSumHitsOf2ndField()
	{
		return g2hits;
	}

	public byte[] getDataBuf() {
		
		return databuf;
	}

	
}
