package cn.sowjz.search.core.query.response;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import cn.sowjz.search.common.VConvert;
import cn.sowjz.search.core.conf.SpecialIdxParser;
import cn.sowjz.search.core.db.FieldInfo;

public class CubeHit extends GroupHit
{

	private List<GroupHit> subhits;
	int groupTotal;
	
	public int byte2Me(byte[] buf, int start, FieldInfo info1, FieldInfo info2,String charset, SpecialIdxParser sParser, int sumFieldNum) throws UnsupportedEncodingException
	{
		int start_bak = start;
		int size=0;
		if (info1.isIntField())
		{
			String key = sParser.getEnumName(info1.getName(),VConvert.bytes2Int(buf, start));
			start += 4;
			int num = VConvert.bytes2Int(buf, start);
			start += 4;
			this.setKey(key);
			this.setNum(num);
			size=VConvert.bytes2Int(buf, start);
			start+=4;
			
		} else if (info1.isInt64Field())
		{
			String key = String.valueOf(VConvert.bytes2Long(buf, start)).trim();
			start += 8;
			int num = VConvert.bytes2Int(buf, start);
			start += 4;
			this.setKey(key);
			this.setNum(num);
			size=VConvert.bytes2Int(buf, start);
			start+=4;
		} else 	if (info1.isBitField())
		{
			String key = sParser.getEnumName(info1.getName(),buf[ start]);
			start += 1;
			int num = VConvert.bytes2Int(buf, start);
			start += 4;
			this.setKey(key);
			this.setNum(num);
			size=VConvert.bytes2Int(buf, start);
			start+=4;
			
		} else
		{
			int len = VConvert.bytes2Int(buf, start);
			start += 4;
			String key = new String(buf, start, len - 1, charset);
			start += len;
			len = VConvert.bytes2Int(buf, start);
			start += 4;
			this.setKey(key);
			this.setNum(len);
			size=VConvert.bytes2Int(buf, start);
			start+=4;
		}
		
		groupTotal=VConvert.bytes2Int(buf, start);
		start+=4;
		if(size>0)
		{
			subhits=new ArrayList<GroupHit>(size);
			for(int i=0;i<size;i++)
			{ GroupHit hit = new GroupHit();
			  start += hit.byte2Me(buf, start, info2, charset,sParser);
			  if(sumFieldNum>0)
					start += hit.byte2SumValues(buf, start, sumFieldNum);
			  subhits.add(hit);
			}  
		}	
		return start - start_bak;
	}

	public void sortByKey()
	{
	  if(subhits!=null)
		Collections.sort(subhits,new GroupHitByKeyComparator()); 
		
	}
	public void sortByValue()
	{
		if(subhits!=null)
		  Collections.sort(subhits,new GroupHitByNumComparator());
	
	}
	public String toString()
	{
		return this.key + " : docs=" + this.getNum() +" Total="+getTotalOfSubGroup()+" return="+this.getSubHitNum()+subhits;
	}
	
	public List<GroupHit> getSubHitList()
	{
		return subhits;
	}
	public int getSubHitNum()
	{
	   if(subhits==null)return 0;
	   return subhits.size();
	}
	public GroupHit getSubHit(int i)
	{
		 if(subhits==null)return null;
		 return subhits.get(i);
	}
	/**
	 * 获取第二字段的总组数
	 * */
	public int getTotalOfSubGroup()
	{
		return groupTotal;
	}
}
