package cn.sowjz.search.core.query.response;

import java.util.ArrayList;
import java.util.List;

import cn.sowjz.search.common.VConvert;
import cn.sowjz.search.core.SearchClient;
import cn.sowjz.search.core.db.FieldInfo;

public class ClusterResponse extends BaseResponse{
	int groupnum;
	int doc_total;
	int total;
	int doc_num;
	int cluWordNum;
	int totalgroupnum;
	
	List<ClusterGroup> grouplist;
	
	FieldInfo finfo;
	
	byte[]databuf;
	
	public ClusterResponse(SearchClient ss)
	{
		super(ss);
	}
	public int byte2Me(byte[] buf) throws Exception{
		return byte2Me(buf,0);
	}
	public int byte2Me(byte[] buf,int start) throws Exception
	{
		databuf=buf;
		String charset = client.feedinfo.getCharset();

	
		groupnum = VConvert.bytes2Int(buf, start);
		start += 4;
		doc_total = VConvert.bytes2Int(buf, start);
		start += 4;
		total = VConvert.bytes2Int(buf, start);
		start += 4;
		doc_num = VConvert.bytes2Int(buf, start);
		start += 4;
		String fn = new String(buf, start, 2, charset);
		start += 2;
		finfo = client.getSchema().find(fn);
		if (finfo == null)
			throw new Exception("The field named : " + fn + " is not exist. ");

		cluWordNum = VConvert.bytes2Int(buf, start);
		start += 4;
		totalgroupnum = VConvert.bytes2Int(buf, start);
		start += 4;
		
		if(groupnum>0)
		{	
			

			grouplist=new ArrayList<ClusterGroup>();

			for(int i=0;i<groupnum;i++)
			{

				ClusterGroup w = new ClusterGroup(client);
				start += w.byte2Me(buf, start, finfo, charset);
				grouplist.add(w);
			}
		}
		return 0;
	}
	public String toString()
	{
		StringBuffer strb=new StringBuffer();
		strb.append("groupnum=").append(groupnum).append("\n")
		.append("kwGTotal=").append(doc_total).append(" kwTotal=").append(total)
		.append(" kwNum=").append(doc_num).append(" cluWordNum=").append(cluWordNum).append("\n");

		for(int i=0;i<groupnum;i++)
		{
			ClusterGroup g=grouplist.get(i);
			strb.append(i).append(" ").append(g).append("\n");
		}	
		return strb.toString();
	}
	
	public int getGroupNum()
	{
		return groupnum;
	}
	
	public List<ClusterGroup> getGroupList()
	{
		return grouplist;
	}
	public int getDocTotal()
	{
		return doc_total;
	}
	public byte[] getDataBuf() {
		
		return databuf;
	}
}
