package cn.sowjz.search.core.query.response;

import java.util.ArrayList;
import java.util.List;

import cn.sowjz.search.common.VConvert;
import cn.sowjz.search.core.SearchClient;
import cn.sowjz.search.core.db.FieldInfo;
import cn.sowjz.search.core.db.Schema;

public class ClusterGroup {

	SearchClient ss;
	
	public ClusterGroup(SearchClient ss)
	{this.ss=ss;
	}
	
	int wordnum;
	int wordlimit;
	List <String>wordlist;
	int docnum;
	int docid[];
	int wordfreq[];
	int docradio;
	int unitnum;
	List <Hit> hitlist;
	
	public int byte2Me(byte[] buf, int start, FieldInfo info, String charset) throws Exception
	{
		
		int start0=start;
		
		wordnum = VConvert.bytes2Int(buf, start);
		start += 4;
		wordlimit= VConvert.bytes2Int(buf, start);
		start += 4;
		
		wordlist=new ArrayList<String>(wordnum);
		for(int j=0;j<wordnum;j++)
		{
			int len = VConvert.bytes2Int(buf, start);
			start += 4;
			String word= new String(buf, start, len-1, charset);
			start += len;
			wordlist.add(word);
		}	
		docnum = VConvert.bytes2Int(buf, start);
		start += 4;
		docradio= VConvert.bytes2Int(buf, start);
		start += 4;
		
		docid=new int[docnum];
		wordfreq=new int[docnum];
		
		for(int i=0;i<docnum;i++)
		{	
			docid[i] = VConvert.bytes2Int(buf, start);
		    start += 4;
		    wordfreq[i] = VConvert.bytes2Int(buf, start);
		    start += 4;
		}
		
		unitnum= VConvert.bytes2Int(buf, start);
		start += 4;
		
		Schema schema = ss.getSchema();
		
		hitlist=new ArrayList<Hit>();
		for(int i=0;i<unitnum;i++)
		{
			Hit hit = new Hit(ss);

			start+= hit.bytes2Me(buf, start, schema, charset);

			hitlist.add(hit);
			   
		}
		return start-start0;
	} 
	
	public String toString()
	{
		StringBuffer strb=new StringBuffer();
		strb.append(wordnum).append("/").append(wordlimit).append("[");
		for(int i=0;i<wordnum;i++)
		  strb.append(wordlist.get(i)).append(",");
	    strb.append("] (").append(docnum).append(",").append(docradio/100.).append("%)");
	    for(int i=0;i<docnum;i++)
	    	strb.append(docid[i]).append("/").append(wordfreq[i]).append(",");
	    for(int i=0;i<unitnum;i++)
	    {
	    	Hit h=hitlist.get(i);
	    	strb.append("\n").append(h.getDoc().getAsString("TI"));
	    }	
		
		return strb.toString();
	}

	public int getWordNum() {
		return wordnum;
	}

	public List<String> getWordList() {
		return wordlist;
	}
	
	public String getWordListStr()
	{
	    StringBuffer strb=new StringBuffer();
	    for(int i=0;i<wordlist.size();i++)
	    {
	    	strb.append(wordlist.get(i)).append(",");
	    }	
		return strb.toString();
	}

	public int getWordLimit() {
		return wordlimit;
	}
	public List<Hit> getHitList(){return hitlist;}
	public double getDocRadio()
	{
		return docradio/10000.;
	}
	public double getDocNumPercentage()
	{
		return docradio/100.;
	}
	public String getFieldCriteria(String originalFieldCrit){
		StringBuffer strb=new StringBuffer();
		if(originalFieldCrit!=null)
			strb.append("(").append(originalFieldCrit).append(") + ");
		strb.append("ANY").append(wordlimit).append("(");
		for(int i=0;i<wordlist.size();i++)
		{
			if(i>0)
				strb.append(",");
			strb.append(wordlist.get(i));
		}	
		strb.append(")");
		System.out.println(strb.toString());
		return strb.toString();
	}
	
}
