package cn.sowjz.search.core.query.request;

import cn.sowjz.search.core.SearchBase;
import cn.sowjz.search.core.db.FieldInfo;

public class WamRequest extends SamplingRequest{
	public WamRequest(SearchBase base) {
		super(base);
		
	}
	public WamRequest(SearchBase sbase, OrderBy sort) {
		super(sbase,sort);
	}

	

	/*maxWord 最多保留多少词
	 * 
	 * maxKeyWordsUsedPerDoc  每篇文章的前多少词用于计算，0：全部
	 * */
	public void setWAMBy(String fieldname, int maxWord)
	{
		setWAMBy(fieldname,maxWord,20);
	}
	public void setWAMBy(String fieldname, int maxWord,int maxKeyWordsUsedPerDoc)
	{
		FieldInfo info = sbase.getSchema().find(fieldname);
		if (null == info)
			throw new IllegalArgumentException("there is no field named: "
					+ fieldname);
		if (!( info.isArticleField())&&(info.getType()!=FieldInfo.TYPE_KWORDS))
			throw new IllegalArgumentException(
					"the field is not ARTICLE or KWORDS type."+fieldname);
		header.type=QueryRequest.QUERY_WAM;
		insertStringTo(header.targetfn,0,fieldname,2);
	    header.maxKeyWords=(short)maxWord;	
	    header.clusterWordNumLimitPerDoc=(short) maxKeyWordsUsedPerDoc;
	}
	
	public String getTargetFieldInHeader()
	{
		return new String (header.targetfn,0,2);
	}
}
