package cn.sowjz.search.core.query.request;

import java.util.ArrayList;
import java.util.List;

import cn.sowjz.search.common.ByteBuff;
import cn.sowjz.search.core.ISearchException;
import cn.sowjz.search.core.SearchBase;
import cn.sowjz.search.core.db.FieldInfo;

public class UnitedRequest extends BaseRequest{

	public UnitedRequest(SearchBase ss) {
		super(ss);
		header.type=UNITED_QUERY;
	}

	List<Execor<?>> exes=new ArrayList<Execor<?>>();
	
	public CritHeader  getExecorCritHeader(int i){
		if(exes.size()<=i) return null;
		return exes.get(i).requ.getCritHeader();
	} 
	
	public BaseRequest getRequestOfExecor(int i)
	{
		if(exes.size()<=i) return null;
		return exes.get(i).getRequest();
	}
	
	public abstract class Execor<T extends BaseRequest>{
		T requ;

		public abstract void verify()throws Exception;
	
		public Execor<T> setOrderByTime() {
			header.orderby=(byte) OrderBy.time.ordinal();
			return this;
		}
		public Execor<T> setOrderByRela() {
			header.orderby=(byte) OrderBy.rela.ordinal();
			return this;
		}
		public Execor<T> setOrderByRamdom() {
			header.orderby=(byte) OrderBy.random.ordinal();
			return this;
		}
		public Execor<T> setOrderByCopies() {
			header.orderby=(byte) OrderBy.copies.ordinal();
			return this;
		}
		public Execor<T> setOrderByTimeAse() {
			header.orderby=(byte) OrderBy.time_asc.ordinal();
			return this;
		}
		public Execor<T> setOrderByFieldDesc(String fieldname) {
			FieldInfo info = sbase.getSchema().find(fieldname);
			if (null == info)
				throw new IllegalArgumentException("there is no field named: "
						+ fieldname);
			if (!(info.isIntField()||info.isInt64Field()))
				throw new IllegalArgumentException(
						"orderByField operate must be with a int field."+fieldname);
			
			insertStringTo(header.orderbyfn,0,fieldname,2);
			header.orderby=(byte) OrderBy.field_desc.ordinal();
			return this;
		}
		public Execor<T> setOrderByFieldAsc(String fieldname) {
			FieldInfo info = sbase.getSchema().find(fieldname);
			if (null == info)
				throw new IllegalArgumentException("there is no field named: "
						+ fieldname);
			if (!(info.isIntField()||info.isInt64Field()))
				throw new IllegalArgumentException(
						"orderByField operate must be with a int field."+fieldname);
			
			insertStringTo(header.orderbyfn,0,fieldname,2);
			header.orderby=(byte) OrderBy.field_asc.ordinal();
			return this;
		}
		public Execor<T> setOrderByFormula(String formula) {
			header.orderby=(byte) OrderBy.formula.ordinal();
			header.formula=formula;
			return this;
		}
		public T getRequest(){
			return requ;
		}
	}
	
	public class  X4Parse extends Execor<BaseRequest>{
		public X4Parse(BaseRequest req){
			this.requ=req;
		}
		@Override
		public void verify() throws Exception {
			
		}
		
	}
	public X4Parse createByRequest(BaseRequest req){
		X4Parse a= new X4Parse(req);
		exes.add(a);
		return a;
	}
	
	public class  Query extends Execor<QueryRequest>{
		public Query(OrderBy orderby){
			requ=new QueryRequest(sbase,orderby,SumType.count);
		}
	
		public Query setStart(int start) {
			requ.setStart(start);		
			return this;
		}
		
		public Query setAskNum(int askNum) {
			requ.setAskNum(askNum);
			return this;
		}
		
		@Override
		public void verify() throws Exception {
			
		}
		public boolean addReltField(String fieldname) throws Exception {
			if(fieldname==null)return false;
			int fl=fieldname.length();
			if(fl!=2 && fl!=4) return false;
			if(fl==4 )
			{	char c1=fieldname.charAt(1);
				if( fieldname.charAt(0)=='0' && (c1=='1'||c1=='2'))
				{
				   int type=c1-'0';
				   String fn=fieldname.substring(2);
				   FieldInfo info = sbase.getSchema().find(fn);
					if (null == info)
						throw new IllegalArgumentException("there is no field named: "
								+ fieldname);
					
				   return addReltField(info,type);
				}   
			    else
			    	return false;
			}
			
			FieldInfo info = sbase.getSchema().find(fieldname);
			if (null == info)
				throw new IllegalArgumentException("there is no field named: "
						+ fieldname);
			return addReltField(info);
		}
		public boolean addReltField(FieldInfo info) throws Exception
		{


			boolean rf=requ.header.addRetField((byte) info.getSn(),(byte) info.getType());
			if(!rf)
				throw new Exception("can not set any more return field "+info.getName());
			return rf;
		}
		private boolean addReltField(FieldInfo info, int type) throws Exception
		{

			if(info.isArticleField()==false)
				throw new IllegalArgumentException("the field is not article field."+info.getName());
			
			boolean rf=requ.header.addRetField((byte) info.getSn(),(byte)type);
			if(!rf)
				throw new Exception("can not set any more return field "+info.getName());
			return rf;
		}
	}
	public Query createQuery(OrderBy sorter){
		Query a= new Query(sorter);
		exes.add(a);
		return a;
	}
	public Query createQuery(){
		return createQuery(OrderBy.time);
	}
	
	public class  Cluster extends Execor<ClusterRequest>{
		public Cluster(){
			requ=new ClusterRequest(sbase);
		}
		public Cluster(OrderBy sort){
			requ=new ClusterRequest(sbase,sort);
		}
		public Cluster setClusterBy(String fieldname)
		{
			return setClusterBy(fieldname,0.6, 5, 3,10,20,30,4000);
		}
		public Cluster setClusterBy(String fieldname,double distance,int maxloop,int minwordnum)
		{
			return setClusterBy(fieldname,distance,maxloop,minwordnum,10,20,30,4000);
		}
		public Cluster setClusterBy(String fieldname,double distance,int maxloop,int minwordnum,int clusterMaxDocInGroup)
		{
			return setClusterBy(fieldname,distance,maxloop,minwordnum,clusterMaxDocInGroup,20,30,4000);
		}
		public Cluster setClusterBy(String fieldname,double distance,int maxloop,int minwordnum,int clusterMaxDocInGroup,int maxgroup,int mxWordPerDoc)
		{
			return setClusterBy(fieldname,distance,maxloop,minwordnum,clusterMaxDocInGroup,maxgroup,mxWordPerDoc,4000);
		}
		
		
		public Cluster setClusterBy(String fieldname,double distance,int maxloop,int minwordnum,int clusterMaxDocInGroup,int maxgroup,int mxWordPerDoc,int wordTotalMaxLimit){
			requ.setClusterBy(fieldname, distance, maxloop, minwordnum, clusterMaxDocInGroup, maxgroup, mxWordPerDoc, wordTotalMaxLimit);
			return this;
		}
		public Cluster setAskNum(int askNum) {
			requ.setAskNum(askNum);
			return this;
		}
		
		@Override
		public void verify() throws Exception {
			if(requ.getQueryType()!=QueryRequest.QUERY_CLUSTER)
			{
				throw new ISearchException("Please call setClusterBy() after createCluster()");
			}
		}
	}
	public Cluster createCluster(){
		Cluster a= new Cluster();
		exes.add(a);
		return a;
	}
	public Cluster createCluster(OrderBy sort){
		Cluster a= new Cluster(sort);
		exes.add(a);
		return a;
	}
	public class  Cube extends Execor<CubeRequest>{
		public Cube(){
			requ=new CubeRequest(sbase);
		}
		public Cube setCubeBy(String field1name,String field2name)throws Exception
		{
			return setCubeBy(field1name,field2name,0);
		}
		public Cube setCubeBy(String field1name,String field2name,int cube2f_max)throws Exception
		{
			requ.setCubeBy(field1name, field2name, cube2f_max);
			return this;
		}
		public Cube setCubeBy(String field1name,long begin,long step,String field2name)throws Exception
		{
			return setCubeBy(field1name,begin,step,field2name,0);
		}
		public Cube setCubeBy(String field1name,int begin,int step,String field2name)throws Exception
		{
			
			return setCubeBy(field1name,begin,step,field2name,0);
		}
		public Cube setCubeBy(String field1name,long begin,long step,String field2name,int cube2f_max)throws Exception
		{
			requ.setCubeBy(field1name, begin, step, field2name, cube2f_max);
			return this;
		}
		public Cube setCubeBy(String field1name,int begin,int step,String field2name,int cube2f_max)throws Exception
		{
			requ.setCubeBy(field1name, begin, step, field2name, cube2f_max);
			return this;
		}
		
		
	
		public Cube setSumFields4Cube(String fieldNames)throws Exception{
			requ.setSumFields4Cube(fieldNames);
			return this;
		}
		public Cube setAskNum(int askNum) {
			requ.setAskNum(askNum);
			return this;
		}
		@Override
		public void verify() throws Exception {
			if(requ.getQueryType()!=QueryRequest.QUERY_CUBE)
			{
				throw new ISearchException("Please call setCubeBy() after createCube()");
			}
		}
	}
	public Cube createCube(){
		Cube a= new Cube();
		exes.add(a);
		return a;

	}
	
	public class  Distinct extends Execor<DistinctRequest>{
		public Distinct(OrderBy sorter){
			requ=new DistinctRequest(sbase,sorter);
		}
		public Distinct(){
			requ=new DistinctRequest(sbase);
		}
		public Distinct setStart(int start) {
			requ.setStart(start);		
			return this;
		}
		
		public Distinct setAskNum(int askNum) {
			requ.setAskNum(askNum);
			return this;
		}
		
		public Distinct setDistinctBy(String fieldname)
		{
			  return setDistinctBy( fieldname,5,true,true);
		}
		public Distinct setDistinctBy(String fieldname,int maxDocInGroup,boolean useLastDateAsGroupDate){
			return setDistinctBy( fieldname,maxDocInGroup,useLastDateAsGroupDate,true);
		}
		public Distinct setDistinctBy(String fieldname,int maxDocInGroup,boolean useLastDateAsGroupDate,boolean returnOtherSequ)
		{
			 requ.setDistinctBy(fieldname, maxDocInGroup, useLastDateAsGroupDate, returnOtherSequ);
			 return this;
		}
		@Override
		public void verify() throws Exception {
			if(requ.getQueryType()!=QueryRequest.QUERY_DISTINCT_INDEX && requ.getQueryType()!=QueryRequest.QUERY_DISTINCT4CTRL)
			{
				throw new ISearchException("Please call setDisinctBy() after createDistinct()");
			}	
			if(requ.getOrderBy()==OrderBy.random)
				throw new ISearchException("distinct doesnt support random sorter.");
		}
		
		public boolean addReltField(String fieldname) throws Exception {
			if(fieldname==null)return false;
			int fl=fieldname.length();
			if(fl!=2 && fl!=4) return false;
			if(fl==4 )
			{	char c1=fieldname.charAt(1);
				if( fieldname.charAt(0)=='0' && (c1=='1'||c1=='2'))
				{
				   int type=c1-'0';
				   String fn=fieldname.substring(2);
				   FieldInfo info = sbase.getSchema().find(fn);
					if (null == info)
						throw new IllegalArgumentException("there is no field named: "
								+ fieldname);
					
				   return addReltField(info,type);
				}   
			    else
			    	return false;
			}
			
			FieldInfo info = sbase.getSchema().find(fieldname);
			if (null == info)
				throw new IllegalArgumentException("there is no field named: "
						+ fieldname);
			return addReltField(info);
		}
		public boolean addReltField(FieldInfo info) throws Exception
		{


			boolean rf=requ.header.addRetField((byte) info.getSn(),(byte) info.getType());
			if(!rf)
				throw new Exception("can not set any more return field "+info.getName());
			return rf;
		}
		private boolean addReltField(FieldInfo info, int type) throws Exception
		{

			if(info.isArticleField()==false)
				throw new IllegalArgumentException("the field is not article field."+info.getName());
			
			boolean rf=requ.header.addRetField((byte) info.getSn(),(byte)type);
			if(!rf)
				throw new Exception("can not set any more return field "+info.getName());
			return rf;
		}		
		
	}
	public Distinct createDistinct(OrderBy sorter){
		Distinct a= new Distinct(sorter);
		exes.add(a);
		return a;
	}
	public Distinct createDistinct(){
		Distinct a= new Distinct();
		exes.add(a);
		return a;
	}
	public class  Group extends Execor<GroupRequest>{
		public Group(){
			requ=new GroupRequest(sbase);
		}
		public Group setGroupBy(String fieldname)throws Exception
		{
			requ.setGroupBy(fieldname);
			return this;			
		}
		public Group setGroupBy(String fieldname,long begin,long step)throws Exception
		{
			requ.setGroupBy(fieldname, begin, step);
			return this;
		}
		public Group setGroupBy(String fieldname,int begin,int step)throws Exception
		{
			requ.setGroupBy(fieldname, begin, step);
			return this;
		}
		public Group setSumFields4Group(String fieldNames)throws Exception{
			requ.setSumFields4Group(fieldNames);
			return this;
		}
		public Group setAskNum(int askNum) {
			requ.setAskNum(askNum);
			return this;
		}
		@Override
		public void verify() throws Exception {
			if(requ.getQueryType()!=QueryRequest.QUERY_GROUP)
			{
				throw new ISearchException("Please call setGroupBy() after createGroup()");
			}
		}
	}
	public Group createGroup(){
		Group a= new Group();
		exes.add(a);
		return a;
	}
	
	public class  WAM extends Execor<WamRequest>{
		public WAM(){
			requ=new WamRequest(sbase);
		}
		public WAM(OrderBy sort){
			requ=new WamRequest(sbase,sort);
		}
		public WAM setWAMBy(String fieldname, int maxWord)
		{
			return setWAMBy(fieldname,maxWord,20);
		}
		public WAM setWAMBy(String fieldname, int maxWord,int maxKeyWordsUsedPerDoc)
		{
			requ.setWAMBy(fieldname, maxWord, maxKeyWordsUsedPerDoc);
			return this;
		}
		public WAM setAskNum(int askNum) {
			requ.setAskNum(askNum);
			return this;
		}
		
		@Override
		public void verify() throws Exception {
			if(requ.getQueryType()!=QueryRequest.QUERY_WAM)
			{
				throw new ISearchException("Please call setWAMBy() after createWAM()");
			}
		}
	}
	public WAM createWAM(){
		WAM a= new WAM();
		exes.add(a);
		return a;
	}
	public WAM createWAM(OrderBy sort){
		WAM a= new WAM(sort);
		exes.add(a);
		return a;
	}
	
	public class  WordCloud extends Execor<WordCloudRequest>{
		public WordCloud(){
			requ=new WordCloudRequest(sbase);
		}
		public WordCloud(OrderBy sort) {
			requ=new WordCloudRequest(sbase,sort);
		}
		public WordCloud setWordCloudBy(String fieldname, int maxWord)
		{
			return setWordCloudBy(fieldname,maxWord,20);
		}
		public WordCloud setWordCloudBy(String fieldname, int maxWord,int maxKeyWordsUsedPerDoc)
		{
			requ.setWordCloudBy(fieldname, maxWord, maxKeyWordsUsedPerDoc);
			return this;
		}
		public WordCloud setAskNum(int askNum) {
			requ.setAskNum(askNum);
			return this;
		}
		@Override
		public void verify() throws Exception {
			if(requ.getQueryType()!=QueryRequest.QUERY_WORDCLOUD)
			{
				throw new ISearchException("Please call setWordCloudBy() after createWordCloud()");
			}
		}
		
	}
	public WordCloud createWordCloud(){
		WordCloud a= new WordCloud();
		exes.add(a);
		return a;
	}
	public WordCloud createWordCloud(OrderBy sort){
		WordCloud a= new WordCloud(sort);
		exes.add(a);
		return a;
	}
	
	public class  KeyWord extends Execor<KeyWordRequest>{
		public KeyWord(OrderBy sorter){
			requ=new KeyWordRequest(sbase,sorter,SumType.count);
		}
		
		public KeyWord setStart(int start) {
			requ.setStart(start);		
			return this;
		}
		
		public KeyWord setAskNum(int askNum) {
			requ.setAskNum(askNum);
			return this;
		}
		public KeyWord setKeyWordsQueryBy(String fieldname)
		{
			requ.setKeyWordsQueryBy(fieldname);
			return this;
		}
		@Override
		public void verify() throws Exception {
			if(requ.getQueryType()!=QueryRequest.QUERY_KEYWORD)
			{
				throw new ISearchException("Please call KeyWordRequest.setKeyWordsQueryBy() first");
			}	
		}
	}
	public KeyWord createKeyWord(OrderBy sorter){
		KeyWord a= new KeyWord(sorter);
		exes.add(a);
		return a;
	}
	
	
	@Override
	public ByteBuff toByteBuff() throws Exception {
		
		if(exes.size()==0)
			throw new Exception("no any Execor defined");
		
		
		int subNum= root.critCount();
		if(subNum>1000)
			throw new Exception("too many subCrit");
		header.subCritNum=(short)subNum;
		
		int execorNum=  exes.size();
		if(execorNum>1000)
			throw new Exception("too many Execor");
		header.execorNum=(short) execorNum;
		
		ByteBuff buf = new ByteBuff(1024);
		
		byte []hf=null;
		
		if(header.orderby==7)
		{	
			if(header.formula==null || header.formula.length()==0)
				throw new Exception("heat function undefined");
			hf=header.formula.getBytes();
			header.heatFuncLen=(short) (hf.length+1);
		}
		header.toByteBuffer(buf);
		
		root.toByteBuffer(buf);

		if(hf!=null)
		{	buf.append(hf);buf.append((byte)0);
		}
		
		for(Execor<?> er:exes){
			
			byte[] hfe=null;
			if(er.requ.header.orderby==7)
			{	
				if(er.requ.header.formula==null || er.requ.header.formula.length()==0)
					throw new Exception("heat function undefined");
				hfe=er.requ.header.formula.getBytes();
				er.requ.header.heatFuncLen=(short) (hfe.length+1);
			}
			
			er.requ.header.toByteBuffer(buf);
			
			if(hfe!=null)
			{	buf.append(hfe);buf.append((byte)0);
			}
		}
		return buf;
	}
	
	@Override
	public byte[] toByteArrayForCache() throws Exception {
		ByteBuff buf = new ByteBuff();
		buf.append(super.toByteArrayForCache());
		
		for(Execor<?> er:exes){
			
			byte[] hfe=null;
			if(er.requ.header.orderby==7)
			{	
				if(er.requ.header.formula==null || er.requ.header.formula.length()==0)
					throw new Exception("heat function undefined");
				hfe=er.requ.header.formula.getBytes();
				er.requ.header.heatFuncLen=(short) (hfe.length+1);
			}
			
			er.requ.header.toByteBuffer(buf);
			
			if(hfe!=null)
			{	buf.append(hfe);buf.append((byte)0);
			}
		}
		
		return buf.getBytes();
	}
	
	
	@Override
	public String toString() {
		
		StringBuffer strb=new StringBuffer();
		
		strb.append("United(");
		
		for(int i=0;i<exes.size();i++){
			if(i>0)
				strb.append(" , ");
			Execor<?> er=(Execor<?>) exes.get(i);
			strb.append(er.requ.header.toString());
		}
		
	    strb.append(")");
	    String tn=header.getTableName();
		if(tn!=null && tn.length()>0 )
			 strb.append(" from ").append(tn.length()<=30?tn:tn.substring(0, 30));
	    
		strb.append(" where ");

		root.toStringBuffer(strb);

		
		
		return strb.toString();
	}
	public void verify() throws Exception{
		for(Execor<?> er:exes){
		   er.verify();
		}
	}
	
}
