package cn.sowjz.search.core.query.request;

import cn.sowjz.search.core.SearchBase;
import cn.sowjz.search.core.db.FieldInfo;

public class QueryRequest extends OrderableRequest{

	
	

	
	
	protected QueryRequest(){
		super();
	}
	
	public QueryRequest(SearchBase ss)
	{
		this(ss, OrderBy.time, SumType.none);
	}
	public QueryRequest(SearchBase ss,  SumType sumtype)
	{
		this(ss, OrderBy.time, sumtype);
	}
	public QueryRequest(SearchBase ss, OrderBy orderby, SumType sumtype) {
		super(ss);
		
		header.orderby=(byte) orderby.ordinal();
		header.sumtype=(byte) sumtype.ordinal();
		header.schlen=20;
		header.type=QUERY_INDEX;
	}

	
	
	

	



	public void setSumType(SumType sumtype) {
		header.sumtype=(byte) sumtype.ordinal();
	}




	public void setStart(int start) {
		header.schbegin=start;
	}
	
	
	

	
	

	
	public boolean addReltField(String fieldname) throws Exception
	{
		if(fieldname==null)return false;
		int fl=fieldname.length();
		if(fl!=2 && fl!=4) return false;
		if(fl==4 )
		{	char c1=fieldname.charAt(1);
			if( fieldname.charAt(0)=='0' && (c1=='1'||c1=='2'))
			{
			   int type=c1-'0';
			   String fn=fieldname.substring(2);
			   FieldInfo info = sbase.getSchema().find(fn);
				if (null == info)
					throw new IllegalArgumentException("there is no field named: "
							+ fieldname);
				
			   return addReltField(info,type);
			}   
		    else
		    	return false;
		}
		
		FieldInfo info = sbase.getSchema().find(fieldname);
		if (null == info)
			throw new IllegalArgumentException("there is no field named: "
					+ fieldname);
		return addReltField(info);
	}
	public boolean addReltField(FieldInfo info) throws Exception
	{


		boolean rf=header.addRetField((byte) info.getSn(),(byte) info.getType());
		if(!rf)
			throw new Exception("can not set any more return field "+info.getName());
		return rf;
	}

	

	private boolean addReltField(FieldInfo info, int type) throws Exception
	{

		if(info.isArticleField()==false)
			throw new IllegalArgumentException("the field is not article field."+info.getName());
		
		boolean rf=header.addRetField((byte) info.getSn(),(byte)type);
		if(!rf)
			throw new Exception("can not set any more return field "+info.getName());
		return rf;
	}




	
	

	
	

	
	


	

	

	
	

	
	

	





	
	
	
	
	
	
	//=========================================================================
	
	
	
	
	
	
	
	/**
	 * txFields:需要做摘要分析的字段，例如TX.要求类型是TYPE_ARTICLE/TYPE_TEXT/TYPE_VARCHAR/TYPE_CLOB
	 * 		  在索引系统中，TX字段包含TI的内容，所以这里不用再包含TI
	 * maxSentence:返回最大句子数
	 * endWithSign:true=正文的句子需要以标点符号结尾，否则抛弃。标题也会被忽略。一般使用false
	 * */
	public void setSummaryQuery(String txFields[],int maxSentence,boolean endWithSign)
	{
		
		if (null == txFields)
			throw new IllegalArgumentException("please enter the  txFields");
		if(txFields.length>5)
			throw new IllegalArgumentException("the number of txFields shouldn't be more than 5.");
		
		
		int i=0;
		for(String tf:txFields)
		{
			FieldInfo info = sbase.getSchema().find(tf);
			if (!( info.isArticleField()||info.getType()==FieldInfo.TYPE_TEXT||info.getType()==FieldInfo.TYPE_VARCHAR
					||info.getType()==FieldInfo.TYPE_LABEL||info.getType()==FieldInfo.TYPE_CLOB))
				throw new IllegalArgumentException(
						"the field is not ARTICLE or TEXT or VARCHAR or CLOB type."+tf);
			System.arraycopy(tf.getBytes(),0,header.summaryQuery_txFields,i,2);
			i+=2;
		}
		
		header.summaryQuery_endWithSign=(byte) (endWithSign?1:0);
		header.summaryQuery_maxSentence=(short) maxSentence;
	}
	
	
	
	
	
	
	


	
	
	

	/*
	 * returnUpdatedSeq 如果值发生了变化，则返回seq字段的值，
	 * */
	public void setUpdateConfig(boolean returnUpdatedSeq){
		header.updateSetting=0;
		if(returnUpdatedSeq)
			header.updateSetting|=1;
	}
	
	
	
	
	
	public void setAskNum(int askNum) {
		header.schlen=askNum;
	}

	public int getAskNum()
	{
		return header.schlen;
	}

	

	
	
	


	
}
