package cn.sowjz.search.core.query.request;

import cn.sowjz.search.core.SearchBase;
import cn.sowjz.search.core.db.FieldInfo;

public class OrderableRequest extends BaseRequest{
	
	public OrderableRequest(SearchBase sbase) {
		super(sbase);
	}
	protected OrderableRequest() {
		super();
	}
	public void setOrderByTime() {
		header.orderby=(byte) OrderBy.time.ordinal();
	}
	public void setOrderByRela() {
		header.orderby=(byte) OrderBy.rela.ordinal();
	}

	public void setOrderByRamdom() throws Exception {
		header.orderby=(byte) OrderBy.random.ordinal();
	}

	public void setOrderByTimeAse() {
		header.orderby=(byte) OrderBy.time_asc.ordinal();
	}
	public void setOrderByFieldDesc(String fieldname) {
		FieldInfo info = sbase.getSchema().find(fieldname);
		if (null == info)
			throw new IllegalArgumentException("there is no field named: "
					+ fieldname);
		if (!(info.isIntField()||info.isInt64Field()))
			throw new IllegalArgumentException(
					"orderByField operate must be with a int field."+fieldname);
		
		insertStringTo(header.orderbyfn,0,fieldname,2);
		header.orderby=(byte) OrderBy.field_desc.ordinal();
	}
	public void setOrderByFieldAsc(String fieldname) {
		FieldInfo info = sbase.getSchema().find(fieldname);
		if (null == info)
			throw new IllegalArgumentException("there is no field named: "
					+ fieldname);
		if (!(info.isIntField()||info.isInt64Field()))
			throw new IllegalArgumentException(
					"orderByField operate must be with a int field."+fieldname);
		
		insertStringTo(header.orderbyfn,0,fieldname,2);
		header.orderby=(byte) OrderBy.field_asc.ordinal();
	}
	public void setOrderByFormula(String formula) {
		header.orderby=(byte) OrderBy.formula.ordinal();
		header.formula=formula;
	}
	

	
	
	public OrderBy getOrderBy(){
		 return OrderBy.values()[header.orderby];
	}
	
	public String getFormula() {
		return header.formula;
	}
	
	
}
