package cn.sowjz.search.core.query.request;

import cn.sowjz.search.core.SearchBase;
import cn.sowjz.search.core.db.FieldInfo;

public class KeyWordRequest extends QueryRequest {
	public KeyWordRequest(SearchBase base) {
		super(base);
		
	}
	
	public KeyWordRequest(SearchBase ss,  SumType sumtype)
	{
		super(ss,sumtype);
	}
	public KeyWordRequest(SearchBase ss, OrderBy orderby, SumType sumtype) {
		super(ss,orderby,sumtype);
	}

	public void setKeyWordsQueryBy(String fieldname)
	{
		FieldInfo info = sbase.getSchema().find(fieldname);
		if (null == info)
			throw new IllegalArgumentException("there is no field named: "
					+ fieldname);
		if (!( info.isArticleField())&& (info.getType()!=FieldInfo.TYPE_KWORDS))
			throw new IllegalArgumentException(
					"the field is not ARTICLE or KWORDS type."+fieldname);
		header.type=QueryRequest.QUERY_KEYWORD;
		insertStringTo(header.targetfn,0,fieldname,2);
	  

	}
	
	public String getTargetFieldInHeader()
	{
		return new String (header.targetfn,0,2);
	}
}
