package cn.sowjz.search.core.query.request;

import java.util.List;

import cn.sowjz.search.core.SearchBase;
import cn.sowjz.search.core.db.FieldInfo;

public class GroupRequest extends BaseRequest {
	public GroupRequest(SearchBase base) {
		super(base);
	
	}
	public boolean setGroupBy(String fieldname)throws Exception
	{
		FieldInfo info = sbase.getSchema().find(fieldname);
		if (null == info)
			throw new IllegalArgumentException("there is no field named: "
					+ fieldname);
		if (( info.isIntField()|| info.isBitField()))
		{
			return setGroupBy(fieldname,0,1);
		}
		if (( info.isInt64Field()))
		{
			return setGroupBy(fieldname,0l,1l);
		}
		if (!(info.isVarcharField() || info.isIntField()||info.isBitField()|| info.isInt64Field()
				||info.isCateField()|| info.getType()==FieldInfo.TYPE_KWORDS))
			throw new IllegalArgumentException(
					"the operate must be compared text field."+fieldname);
		header.type=QueryRequest.QUERY_GROUP;
		header.group_type=1;		
		insertStringTo(header.targetfn,0,fieldname,2);
		return true;
		
	}
	public boolean setGroupBy(String fieldname,long begin,long step)throws Exception
	{
		FieldInfo info = sbase.getSchema().find(fieldname);
		if (null == info)
			throw new IllegalArgumentException("there is no field named: "
					+ fieldname);
		if(info.isInt32TimeField())
		{
			return setGroupBy(fieldname,docValueHelper.timeToInt32(begin, info.isUnsign()),docValueHelper.timeToInt32(step, info.isUnsign()));
			//return setGroup(fieldname,(int)begin,(int)step);
		}	
		if (!(info.isInt64Field()))
			throw new IllegalArgumentException(
					"the group field must be int or bit field."+fieldname);
		if(step==0)
			throw new Exception("the step value cannot be 0");
		
		header.type=QueryRequest.QUERY_GROUP;
		header.group_type=1;
		insertStringTo(header.targetfn,0,fieldname,2);
		header.groupBegin=begin;
		header.groupStep=step;
		return true;
	}
	public boolean setGroupBy(String fieldname,int begin,int step)throws Exception
	{
		FieldInfo info = sbase.getSchema().find(fieldname);
		if (null == info)
			throw new IllegalArgumentException("there is no field named: "
					+ fieldname);
		if (!( info.isIntField()|| info.isBitField()))
			throw new IllegalArgumentException(
					"the group field must be int or bit field."+fieldname);
		if(step==0)
			throw new Exception("the step value cannot be 0");
		
		header.type=QueryRequest.QUERY_GROUP;
		header.group_type=1;
		insertStringTo(header.targetfn,0,fieldname,2);
		header.groupBegin=begin;
		header.groupStep=step;
		return true;
	}
	
	
	/**
	 * 
	 * fieldNames : 需要累加的字段名称，如果多个用小写逗号隔开。例如  req.setSumFields4Group("IN,BY,SH,IT");
	 * 字段类型包括，byte,short,int24,int
	 * 
	 * */
	public void setSumFields4Group(String fieldNames)throws Exception{
		if(fieldNames==null || fieldNames.length()==0)
			return ;
		
		if(sbase.feedinfo.version%1000<138)
			throw new Exception("The version of isearch is low, please update to Verx138 at least.");
		
		String fs[]=fieldNames.split(",");
		
		int len=fs.length;
		if(len>20)
			throw new Exception("The number of field to sum should less or equal 20.");
		
		header.retfnum=0;
		for(String fn:fs){
			
			FieldInfo info = sbase.getSchema().find(fn);
			if (null == info)
				throw new IllegalArgumentException("there is no field named: "
						+ fn);
			if (!( info.isIntField() || info.isInt64Field()))
				throw new IllegalArgumentException(
						"the field("+fn+") is not a Int type.");
			header.addRetField((byte)info.getSn(), (byte)info.getType());
		}
	
	}
	public void setSumFields4Group(List<String> fieldNames)throws Exception{
		if(fieldNames==null || fieldNames.size()==0)
			return ;
		
		if(sbase.feedinfo.version%1000<138)
			throw new Exception("The version of isearch is low, please update to Verx138 at least.");
		
	
		
		int len=fieldNames.size();
		if(len>20)
			throw new Exception("The number of field to sum should less or equal 20.");
		
		header.retfnum=0;
		for(String fn:fieldNames){
			
			FieldInfo info = sbase.getSchema().find(fn);
			if (null == info)
				throw new IllegalArgumentException("there is no field named: "
						+ fn);
			if (!( info.isIntField() || info.isInt64Field()))
				throw new IllegalArgumentException(
						"the field("+fn+") is not a Int type.");
			header.addRetField((byte)info.getSn(), (byte)info.getType());
		}
	
	}
	
	public String getTargetFieldInHeader()
	{
		return new String (header.targetfn,0,2);
	}
	public void setAskNum(int askNum) {
		header.schlen=askNum;
	}

	public int getAskNum()
	{
		return header.schlen;
	}
}
