package cn.sowjz.search.core.query.request;

import cn.sowjz.search.core.SearchBase;
import cn.sowjz.search.core.db.FieldInfo;

public class DistinctRequest extends QueryRequest {
	
	public DistinctRequest(SearchBase base) {
		super(base,SumType.count);
		
	}
	
	public DistinctRequest(SearchBase ss, OrderBy orderby) {
		super(ss,orderby,SumType.count);
	}

	public void setDistinctBy(String fieldname)
	{
		  setDistinctBy( fieldname,5,true,true);
	}
	

	
	
	
	public void setDistinctBy(String fieldname,int maxDocInGroup,boolean useLastDateAsGroupDate){
		setDistinctBy( fieldname,maxDocInGroup,useLastDateAsGroupDate,true);
	}
	/**
	 * maxArticleInGroup=0: no limited
	 * 
	 * */
	public void setDistinctBy(String fieldname,int maxDocInGroup,boolean useLastDateAsGroupDate,boolean returnOtherSequ)
	{
		FieldInfo info = sbase.getSchema().find(fieldname);
		if (null == info)
			throw new IllegalArgumentException("there is no field named: "
					+ fieldname);
		if (!( info.isArticleField()||info.isByte16Field()))
			throw new IllegalArgumentException(
					"the field is not ARTICLE or BYTE16 type."+fieldname);
		
		header.type=QueryRequest.QUERY_DISTINCT_INDEX;
		insertStringTo(header.targetfn,0,fieldname,2);
		header.dCMax=maxDocInGroup;
		header.distinctKeyDoc=(byte) (useLastDateAsGroupDate?0:1);
		
		if(sbase.feedinfo.version%1000>138)
			header.distinctKeyDoc+=(byte) (returnOtherSequ?0:4);
		
	}
	
	public String getTargetFieldInHeader()
	{
		return new String (header.targetfn,0,2);
	}
	
	public void setOrderByCopies() {
		header.orderby=(byte) OrderBy.copies.ordinal();
	}
	@Override
	public void setOrderByRamdom() throws Exception {
		throw new Exception("distinct doesnt support random sorter.");
	}
	
	
}
