package cn.sowjz.search.core.query.request;

import java.util.List;

import cn.sowjz.search.core.SearchBase;
import cn.sowjz.search.core.db.FieldInfo;

public class CubeRequest extends BaseRequest{

	
	public CubeRequest(SearchBase base) {
		super(base);
	
	}
	
	/**
	 * 
	 * fieldNames : 需要累加的字段名称，如果多个用小写逗号隔开。例如  req.setSumFields4Group("IN,BY,SH,IT");
	 * 字段类型包括，byte,short,int24,int
	 * 
	 * */
	public void setSumFields4Cube(String fieldNames)throws Exception{
		if(fieldNames==null || fieldNames.length()==0)
			return ;
		
		if(sbase.feedinfo.version%1000<150)
			throw new Exception("The version of isearch is low, please update to Verx150 at least.");
		
		String fs[]=fieldNames.split(",");
		
		int len=fs.length;
		if(len>20)
			throw new Exception("The number of field to sum should less or equal 20.");
		
		header.retfnum=0;
		for(String fn:fs){
			
			FieldInfo info = sbase.getSchema().find(fn);
			if (null == info)
				throw new IllegalArgumentException("there is no field named: "
						+ fn);
			if (!( info.isIntField() || info.isInt64Field()))
				throw new IllegalArgumentException(
						"the field("+fn+") is not a Int type");
			header.addRetField((byte)info.getSn(), (byte)info.getType());
		}
	
	}
	public void setSumFields4Cube(List<String> fieldNames)throws Exception{
		if(fieldNames==null || fieldNames.size()==0)
			return ;
		
		if(sbase.feedinfo.version%1000<138)
			throw new Exception("The version of isearch is low, please update to Verx138 at least.");
		
	
		
		int len=fieldNames.size();
		if(len>20)
			throw new Exception("The number of field to sum should less or equal 20.");
		
		header.retfnum=0;
		for(String fn:fieldNames){
			
			FieldInfo info = sbase.getSchema().find(fn);
			if (null == info)
				throw new IllegalArgumentException("there is no field named: "
						+ fn);
			if (!( info.isIntField() || info.isInt64Field()))
				throw new IllegalArgumentException(
						"the field("+fn+") is not a Int type.");
			header.addRetField((byte)info.getSn(), (byte)info.getType());
		}
	
	}
	
	public boolean setCubeBy(String field1name,String field2name)throws Exception
	{
		return setCubeBy(field1name,field2name,0);
	}
	public boolean setCubeBy(String field1name,String field2name,int cube2f_max)throws Exception
	{
		FieldInfo info1 = sbase.getSchema().find(field1name);
		if (null == info1)
			throw new IllegalArgumentException("there is no field named: "
					+ field1name);
		if (( info1.isIntField()|| info1.isInt64Field()||info1.isBitField()))
		{
			return setCubeBy(field1name,0,1,field2name,cube2f_max);
		}	
		if (!(info1.isVarcharField() || info1.isIntField()||info1.isBitField()
				|| info1.isInt64Field()||info1.isCateField()|| info1.getType()==FieldInfo.TYPE_KWORDS))
			throw new IllegalArgumentException(
					"this field can not be defined for cube first field."+field1name);
		
		FieldInfo info2 = sbase.getSchema().find(field2name);
		if (null == info2)
			throw new IllegalArgumentException("there is no field named: "
					+ field2name);
		if (!(info2.isVarcharField() || info2.isIntField()||info2.isBitField()
				||info2.isCateField()|| info2.getType()==FieldInfo.TYPE_KWORDS))
			throw new IllegalArgumentException(
					"this field can not be defined for cube second field."+field2name);
		
		header.type=QueryRequest.QUERY_CUBE;
		header.group_type=1;		
		insertStringTo(header.targetfn,0,field1name,2);
		header.groupBegin=0;
		header.groupStep=0;
		header.cube_type=1;
		header.cube2f_max=cube2f_max;
		insertStringTo(header.cube2fn,0,field2name,2);
		return true;
		
	}
	public int getCube2f_max()
	{
		return header.cube2f_max;
	}
	public boolean setCubeBy(String field1name,long begin,long step,String field2name)throws Exception
	{
		return setCubeBy(field1name,begin,step,field2name,0);
	}
	public boolean setCubeBy(String field1name,int begin,int step,String field2name)throws Exception
	{
		return setCubeBy(field1name,begin,step,field2name,0);
	}
	public boolean setCubeBy(String field1name,long begin,long step,String field2name,int cube2f_max)throws Exception
	{
		FieldInfo info = sbase.getSchema().find(field1name);
		if (null == info)
			throw new IllegalArgumentException("there is no field named: "
					+ field1name);
		if(info.isInt32TimeField())
		{
			return setCubeBy(field1name,docValueHelper.timeToInt32(begin, info.isUnsign()),docValueHelper.timeToInt32(step, info.isUnsign()),field2name,cube2f_max);
			//return setCube(field1name,(int)(begin),(int)(step),field2name,cube2f_max);
		}	
		if (!(  info.isInt64Field()))
			throw new IllegalArgumentException(
					"this field can not be defined for cube first field."+field1name);
		if(step==0)
			throw new Exception("the step value cannot be 0");
		
		FieldInfo info2 = sbase.getSchema().find(field2name);
		if (null == info2)
			throw new IllegalArgumentException("there is no field named: "
					+ field2name);
		if (!(info2.isVarcharField() || info2.isIntField()||info2.isBitField()||info2.isCateField()||info2.getType()==FieldInfo.TYPE_KWORDS))
			throw new IllegalArgumentException(
					"this field can not be defined for cube second field."+field2name);
		
		header.type=QueryRequest.QUERY_CUBE;
		header.group_type=1;
		insertStringTo(header.targetfn,0,field1name,2);
		header.groupBegin=begin;
		header.groupStep=step;
		header.cube_type=1;
		header.cube2f_max=cube2f_max;
		insertStringTo(header.cube2fn,0,field2name,2);
		
		return true;
	}
	public boolean setCubeBy(String field1name,int begin,int step,String field2name,int cube2f_max)throws Exception
	{
		FieldInfo info = sbase.getSchema().find(field1name);
		if (null == info)
			throw new IllegalArgumentException("there is no field named: "
					+ field1name);
		if (!( info.isIntField()||  info.isInt64Field()|| info.isBitField()))
			throw new IllegalArgumentException(
					"this field can not be defined for cube first field."+field1name);
		if(step==0)
			throw new Exception("the step value cannot be 0");
		
		FieldInfo info2 = sbase.getSchema().find(field2name);
		if (null == info2)
			throw new IllegalArgumentException("there is no field named: "
					+ field2name);
		if (!(info2.isVarcharField() || info2.isIntField()||info2.isBitField()||info2.isCateField()||info2.getType()==FieldInfo.TYPE_KWORDS))
			throw new IllegalArgumentException(
					"this field can not be defined for cube second field."+field2name);
		
		header.type=QueryRequest.QUERY_CUBE;
		header.group_type=1;
		insertStringTo(header.targetfn,0,field1name,2);
		header.groupBegin=begin;
		header.groupStep=step;
		header.cube_type=1;
		header.cube2f_max=cube2f_max;
		insertStringTo(header.cube2fn,0,field2name,2);
		
		return true;
	}
	
	
	public String getTargetFieldInHeader()
	{
		return new String (header.targetfn,0,2);
	}
	public void setAskNum(int askNum) {
		header.schlen=askNum;
	}

	public int getAskNum()
	{
		return header.schlen;
	}
}
