package cn.sowjz.search.core.query.request;

import cn.sowjz.search.core.SearchBase;
import cn.sowjz.search.core.db.FieldInfo;

public class ClusterRequest extends SamplingRequest{
	
	public ClusterRequest(SearchBase base) {
		super(base);
		
	}
	

	public ClusterRequest(SearchBase sbase, OrderBy sort) {
		super(sbase,sort);
	}


	public void setClusterBy(String fieldname)
	{
		setClusterBy(fieldname,0.6, 5, 3,10,20,30,4000);
	}
	public void setClusterBy(String fieldname,double distance,int maxloop,int minwordnum)
	{
		setClusterBy(fieldname,distance,maxloop,minwordnum,10,20,30,4000);
	}
	public void setClusterBy(String fieldname,double distance,int maxloop,int minwordnum,int clusterMaxDocInGroup)
	{
		setClusterBy(fieldname,distance,maxloop,minwordnum,clusterMaxDocInGroup,20,30,4000);
	}
	public void setClusterBy(String fieldname,double distance,int maxloop,int minwordnum,int clusterMaxDocInGroup,int maxgroup,int mxWordPerDoc)
	{
		setClusterBy(fieldname,distance,maxloop,minwordnum,clusterMaxDocInGroup,maxgroup,mxWordPerDoc,4000);
	}
	
	/**
	 * fieldname:
	 * distance:
	 * maxloop:
	 * minwordnum:
	 * clusterMaxDocInGroup:
	 * maxgroup:最多返回多少组，0表示全部
	 * mxWordPerDoc:
	 * minDocPerWord:
	 * */
	public void setClusterBy(String fieldname,double distance,int maxloop,int minwordnum,int clusterMaxDocInGroup,int maxgroup,int mxWordPerDoc,int wordTotalMaxLimit)
	{
		FieldInfo info = sbase.getSchema().find(fieldname);
		if (null == info)
			throw new IllegalArgumentException("there is no field named: "
					+ fieldname);
		if (!( info.isArticleField()) && (info.getType()!=FieldInfo.TYPE_KWORDS))
			throw new IllegalArgumentException(
					"the field is not ARTICLE or KWORDS type."+fieldname);
		header.type=QueryRequest.QUERY_CLUSTER;
		header.clusterMaxDocInGroup=(short) clusterMaxDocInGroup;
		insertStringTo(header.targetfn,0,fieldname,2);
		header.cluster(distance, maxloop, minwordnum,(short)maxgroup,(short)mxWordPerDoc,(short)wordTotalMaxLimit);
	}
	public String getTargetFieldInHeader()
	{
		return new String (header.targetfn,0,2);
	}


	
	

	
}
