package cn.sowjz.search.core.query.request;

import cn.sowjz.search.common.ByteBuff;
import cn.sowjz.search.common.util.charset.String2Bytes;
import cn.sowjz.search.core.Constants;
import cn.sowjz.search.core.SearchBase;
import cn.sowjz.search.core.SearchClient;
import cn.sowjz.search.core.db.FieldInfo;
import cn.sowjz.search.core.util.DocValueHelper;

public class BaseRequest {
	SearchBase sbase;
	
	protected CritHeader header;
	String charset;
	String2Bytes str2bytes;
	
	public final static int QUERY_INDEX=0;
	public final static int QUERY_GROUP=1;
	public final static int QUERY_DISTINCT_INDEX=2;
	public final static int QUERY_CUBE=3;
	public final static int QUERY_KEYWORD=4;
	public final static int QUERY_WORDCLOUD=5;
	public final static int QUERY_WAM=6;
	public final static int QUERY_CLUSTER=7;
	public final static int UNITED_QUERY=8;
	public final static int QUERY_DISTINCT4CTRL=9;
	
	public final static int AND_OP	=-1;
	public final static int OR_OP	=-2;
	public final static int AND_NOT_OP	=-3;
	public final static int OR_NOT_OP	=-4;
	
	

	protected DocValueHelper docValueHelper;
	protected BaseRequest(){
		docValueHelper=new DocValueHelper();
	}
	
	public BaseRequest(SearchBase sbase) {
		if (null == sbase.getSchema())
			throw new RuntimeException(
					"the System FieldInofs is null. please check the is full db exist?");
		this.sbase = sbase;
		
	
		charset=sbase.getCharset();
		str2bytes=String2Bytes.getInstance(charset);
		docValueHelper=new DocValueHelper();
		header =new CritHeader(this,0);
	}

	
	
	public SearchBase getSearchBase(){
		return sbase;
	}
	public CritHeader getHeader(){return header;}
	
	
	
	public static enum OrderBy{
		time,rela,random,copies,time_asc,field_desc,field_asc,formula;
		
	}
	public static enum SumType{
		none,count,estimate;
	}
	
	public int getQueryType()
	{
		return header.type;
	}
	
	public String toString()
	{
		
		StringBuffer strb=new StringBuffer();
		
		strb.append(header.toString());
	
		
		strb.append(" where ");

		if(root!=null)
		  root.toStringBuffer(strb);

	
		return strb.toString();
	}
	public byte[] toByteArrayForCache() throws Exception {
		
		byte []hf=null;
		if(header.orderby==7)
		{	
			if(header.formula==null || header.formula.length()==0)
				throw new Exception("heat function undefined");
			hf=header.formula.getBytes();
			header.heatFuncLen=(short)( hf.length+1);
		}else
			header.heatFuncLen=0;
		
		
		int subCritNum= root.critCount();
		if(subCritNum>1000)
			throw new Exception("too many subCrit");
		header.subCritNum=(short)subCritNum;
		
		
		ByteBuff buf = new ByteBuff();
		
		header.toByteBuffer(buf);
		
		root.toByteArrayForCache(buf);
		
		
		if(hf!=null)
		{	buf.append(hf);
		    buf.append((byte)0);
		}
//	    System.out.println(buf.getUsed());
//System.out.println(buf.toHexString());
		
		return buf.getBytes();
	}
	
	public ByteBuff toByteBuff() throws Exception {
		
		
		
		ByteBuff buf = new ByteBuff(1024);
		
		byte []hf=null;
		
		int subCritNum= root.critCount();
		if(subCritNum>1000)
			throw new Exception("too many subCrit");
		header.subCritNum=(short)subCritNum;
		
		if(header.orderby==7)
		{	
			if(header.formula==null || header.formula.length()==0)
				throw new Exception("heat function undefined");
			hf=header.formula.getBytes();
			header.heatFuncLen=(short) (hf.length+1);
		}
		header.toByteBuffer(buf);
		
		root.toByteBuffer(buf);

		if(hf!=null)
		{	buf.append(hf);buf.append((byte)0);
		}
		return buf;
	}

	SubCrit root=null;
	public void mergeAnd(SubCrit bt){
		if(root==null ||root.isEmpty())
			root=bt;
		else{
		
			root= root.mergeAnd(bt);
		}
	}
	
	public void and(SubCrit bt){
		if(root==null)
			root=bt;
		else
			root=root.mergeAnd(bt);
		
	}

	public void or(SubCrit bt){
		if(root==null)
			root=bt;
		else 
			root=root.or(bt);
	
	}
	public void andNot(SubCrit bt){
		if(root==null)
			root=bt;
		else 
			root=root.andNot(bt);
		
	}
	public void orNot(SubCrit bt){
		if(root==null)
			root=bt;
		else 
			root=root.orNot(bt);
	}
	
	
	
	public FieldInfo getFieldInfo(String fieldname){
		return sbase.getSchema().find(fieldname);
	}
	
	
	
	public void useTable(String table_name) throws Exception{
		SearchClient.check_table_name(table_name);
		header.setTableName(table_name);
	}

	public void setOnlyUseCharIndex(boolean onlyUseCharIndex){
		header.onlyUseCharIndex=(byte) (onlyUseCharIndex?1:0);
	}
	
//	public byte[]getFieldCritValue(String fieldname,byte operator){
//		if(root==null)return null;
//		return root.getFieldCritValue(fieldname, operator);
//	}	
	protected void insertStringTo(byte[] ftv,int begin, String v,int strlen) 
	{
		byte[] bb=v.getBytes();
		
		for(int i=0;i<strlen;i++)
		{
			ftv[begin+i]=bb[i];
		}	
	}
	
	public Criteria createCriteria(){
		if(root==null)
			root= new  SubCrit(this);
		return root;
	}
	
	
	public SubCrit createSubCrit(){
		return new SubCrit(this);
	}
	public CritHeader getCritHeader() 
	{
		
		return header;
	}
	
	public String getQueryTypeName() {
		int qt=getQueryType();
		if(qt>=0&& qt<Constants.QueryType.length)
			return Constants.QueryType[qt];
		return "UNKOWN TYPE("+qt+")";
	}
	
	public void setFocusOn(int host_sn){
		header.focusOn=(short) (1024+(host_sn & 0x3ff));
	}
	
	public void setSimhashThreshold(byte threshold)
	{
		header.simhash_threshold=threshold;
	}
	//----------------------------------------------------------------

	

}
