package cn.sowjz.search.core.query.draw;

import cn.sowjz.search.core.query.response.DmkWord;
import cn.sowjz.search.core.query.response.WordCloudResponse;

public class WordCloudHtml {

	WordCloudResponse hits;
	
	public WordCloudHtml( WordCloudResponse hits)
	{
		this.hits=hits;
	}
	
	final String[] colors={"BLUE","GREEN","BLACK"};
	public String toHTML(String stopwords[])
	{
	    int wn=hits.getWordnum();
	    if(wn<=0)
	    	return "there is no any keywords!";
	    int maxm=hits.getWord(0).getMark();
	   // int minm=hits.getWord(wn-1).getMark();
	    int mxsize=150;//16*maxm/minm;
	    StringBuffer strb=new StringBuffer();
	    for(int i=0;i<wn;i++)
	    {
	    	DmkWord w=hits.getWord(i);
	    	if(isInStop(w,stopwords)) continue;
	    	maxm=hits.getWord(i).getMark();
	    	break;
	    }
	    
	    for(int i=0;i<wn;i++)
	    {
	    	DmkWord w=hits.getWord(i);
	    	if(isInStop(w,stopwords)) continue;
	    	strb.append("<font style=\"font-size:").append((int)(w.getMark()*mxsize/maxm))
	    	    .append("px;color:").append(colors[i%3]).append("\">")
	    	    .append(w.getWord()).append("&nbsp;</font>");
	    } 	
	    return strb.toString();
	}


	private boolean isInStop(DmkWord w, String[] stopwords) 
	{
		if(stopwords==null)
			return false;
		for(int i=0;i<stopwords.length;i++)
		{
			if(stopwords[i].equalsIgnoreCase(w.getWord()))
				return true;
		}
	    return false;
	}
	
	
}
