package cn.sowjz.search.core.query.draw;

public class WamListHtml 
{
	WamCNode root;
    public WamListHtml(WamCNode root)
    {
    	this.root=root;
    }
    
    public String toText()
    {
    	if(root==null)
    		return null;
    	StringBuffer strb=new StringBuffer();
    	
    	addNodeToStrB(root,strb,"");
    	return strb.toString();
    }

	private void addNodeToStrB(WamCNode node, StringBuffer strb, String header) 
	{
		strb.append(header).append(node.toString()).append("\n");
		
		header=header.replace('┣', '┃');
		header=header.replace('┗', '　');
		WamCNode cn[]=node.childArray();
		if(cn!=null)
			for(int i=0;i<cn.length;i++)
			{	if(i==cn.length-1)
				    addNodeToStrB(cn[i],strb,header+"┗");
			    else addNodeToStrB(cn[i],strb,header+"┣");
			    
			}
	}
	
	  public String toHtmlTable()
	    {
	    	if(root==null)
	    		return null;
	    	StringBuffer strb=new StringBuffer();
	    	strb.append("<table border=1 cellpadding=0 cellspacing=0 >\n");
	    	strb.append("<tr><th>WORD</th><th>RADIUS</th><th>ANGLE</th><th>MARK</th><th>DOCNUM</th></tr>\n");
	    	addNodeToStrB_HT(root,strb,"");
	    	strb.append("</table>\n");
	    	return strb.toString();
	    }

	private void addNodeToStrB_HT(WamCNode node, StringBuffer strb, String header) 
	{
		strb.append("<tr><td>");
		strb.append(header).append(node.getWord()).append("</td><td>")
		    .append(node.getRadius()).append("</td><td>")
		    .append(node.getAngle()).append("</td><td>")
		    .append(node.getMark()).append("</td><td>")
		    .append(node.getDocnum());
		strb.append("</td></tr>").append("\n");
		
		header=header.replace('┣', '┃');
		header=header.replace('┗', '　');
		WamCNode cn[]=node.childArray();
		if(cn!=null)
			for(int i=0;i<cn.length;i++)
			{	if(i==cn.length-1)
				   addNodeToStrB_HT(cn[i],strb,header+"┗");
			    else addNodeToStrB_HT(cn[i],strb,header+"┣");
			    
			}
		
	}
}
