package cn.sowjz.search.core.query.draw;

import java.util.List;

import cn.sowjz.search.common.ByteBuff;
import cn.sowjz.search.core.Constants;

public class WamHtml {

	int radius;
	public WamHtml(int radius)
	{
	  this.radius=radius/2*2;	
	}
	
	short map[][];
	List<WamCNode> datalist;
	public void fillIn(List<WamCNode> result) {
		datalist=result;
		
		map=new short[radius*2+1][radius+1];
		if(result==null)return;
		
		double maxr=0;
		for(int i=0;i<result.size();i++)
		{
			WamCNode n=(WamCNode)result.get(i);
			if(n.getRadius()>maxr)
				maxr=n.getRadius();
		}
		if(maxr==0)return;
		double indexr=radius/maxr;
		
		for(int i=0;i<result.size();i++)
		{
			WamCNode n=(WamCNode)result.get(i);
			
			int x=(int)(indexr*n.getRadius()*Math.cos(n.getAngle()*3.14/180));
			int X=x+radius;
			int y=(int)(indexr*n.getRadius()*Math.sin(n.getAngle()*3.14/180)/2);
			int Y=y+radius/2;
			
			//System.out.println("word "+n.getWord()+" X="+X+" Y="+Y + " d=" + ((X-61)*(X-61)+(Y-31)*(Y-31)));
			boolean finished=false;
			int a=1;
			while(!finished)
			{
				if(map[X][Y]==0)
				{
					map[X][Y]=(short) (i+1);
					break;
				}	
				
				for(int i0=0;i0<a;i0++)
				{
					if(x>=0)
						X=x+radius+i0;
					else X=x+radius-i0;
					if(X>radius*2) X=radius*2;
					else if(X<0)X=0;
					for(int i1=0;i1<a;i1++)
					{
						if(y>=0)
							Y=y+radius/2+i1;
						else Y=y+radius/2-i1;
						if(Y>radius) Y=radius;
						else if(Y<0)Y=0;
						if(map[X][Y]==0)
						{
							map[X][Y]=(short) (i+1);
	//System.out.println("word2 "+n.getWord()+" X="+X+" Y="+Y + " d=" + ((X-61)*(X-61)+(Y-31)*(Y-31)));
							finished=true;
							break;
						}	
					}
					if(finished)
						break;
					a++;
					if((X==radius*2||X==0) &&( Y==radius||Y==0))
					{	
						System.out.println("cannot put in "+n.getWord());
						break;
					
					}
				}	
				
			}	
			
		}		
		
	}
	
	public String output_X() {
		StringBuffer strb=new StringBuffer();
		int x=radius*2+1;
		int y=radius+1;
	   
	   for(int j=0;j<y;j++)
	   {
		   for(int i=0;i<x;i++) 
		    if(map[i][j]==0)	   
		    	strb.append(" ");
		    else strb.append("X");
		   strb.append("\n");
	   }	   
	   return strb.toString();
	}
	public String output_text() throws Exception {
		int x=radius*2+1;
		int y=radius+1;
		byte charmap[][]=new byte[y][x];

		for(int j=0;j<y;j++)
		{
			   for(int i=0;i<x;i++) 
			    if(map[i][j]!=0)	   
			    	charmap[j][i]='X';
		}	   
	   for(int j=0;j<y;j++)
	   {
		   for(int i=0;i<x;i++) 
		   {
			   if(map[i][j]!=0)
			   {
				   WamCNode n=(WamCNode) datalist.get(map[i][j]-1);
				   byte wb[]=n.getWord().getBytes(Constants.GBK);
				   if(output_text_left(wb,i,j,charmap)==false)
					   if(output_text_right(wb,i,j,charmap)==false)
					   if(output_text_top(wb,i,j,charmap)==false)
							   if(output_text_bottom(wb,i,j,charmap)==false)
								   System.out.println("can not put "+n.getWord()+" in the map");
			   }	   
		   }
		   
	   }	
	   
	   for(int j=0;j<y;j++)
		{
			   for(int i=0;i<x;i++) 
			    if(charmap[j][i]==0)	   
			    	charmap[j][i]=' ';
		}	
	   StringBuffer strb=new StringBuffer();
	   for(int j=0;j<y;j++)
	   {
		 //  System.out.println("bytelen="+charmap[j].length+" strlen="+new String(charmap[j],"GBK").length());
		   strb.append(new String(charmap[j],Constants.GBK)).append("\n");
	   }
	   return strb.toString();
	}

	private boolean output_text_left (byte[] wb, int x, int y, byte[][] charmap) 
	{
		
		int size=wb.length;
	
		
		if(x<size) return false;
		int a=0;
		for(int i=x-size;i<x;i++)
		  a+=(charmap[y][i]==0)?0:1;
		if(a>0)		return false;
		for(int i=0;i<size;i++)
		  charmap[y][i+x-size]=wb[i];
		charmap[y][x]='L';
		return true;
	}

	private boolean output_text_right(byte[] wb, int x, int y, byte[][] charmap) {
		int size=wb.length;
		
		if(x+size>=radius*2) return false;
		int a=0;
		for(int i=x+1;i<x+size+1;i++)
		  a+=(charmap[y][i]==0)?0:1;
		if(a>0)		return false;
		for(int i=0;i<size;i++)
		  charmap[y][i+x+1]=wb[i];
		charmap[y][x]='R';
		return true;
	}

	private boolean output_text_top(byte[] wb, int x, int y, byte[][] charmap) {
		int size=wb.length;
		
		if(y==0) return false;
		int y0=y-1;
		
		int begin=x-size/2;
		
		if(begin>=0 && begin+size+2<radius*2)
		{
		   int a=0;
		   for(int i=0;i<size+2;i++)
		     if(charmap[y0][i+begin]==0)a++;
		     else break;
		
		  if(a==size+2)	
		  {
		    for(int i=0;i<size;i++)
		     charmap[y0][i+begin+1]=wb[i];
		    charmap[y][x]='U';
		    return true;
		  }
		}
		
		for(int k=1;k<size;k++)
		{
			if(k%2==0) begin=x-size/2+k/2;
			else  begin=x-size/2-k/2;
			if(begin>=0 && begin+size+2<radius*2)
			{
			   int a=0;
			   for(int i=0;i<size+2;i++)
			     if(charmap[y0][i+begin]==0)a++;
			     else break;
			
			  if(a==size+2)	
			  {
			    for(int i=0;i<size;i++)
			     charmap[y0][i+begin+1]=wb[i];
			    charmap[y][x]='U';
			    return true;
			  }
			}  
		}
		
		return false;
	}

	private boolean output_text_bottom(byte[] wb, int x, int y, byte[][] charmap)
	{
	int size=wb.length;
		
		if(y==radius) return false;
		int y0=y+1;
		
		int begin=x-size/2;
		
		if(begin>=0 && begin+size+2<radius*2)
		{
		   int a=0;
		   for(int i=0;i<size+2;i++)
		     if(charmap[y0][i+begin]==0)a++;
		     else break;
		
		  if(a==size+2)	
		  {
		    for(int i=0;i<size;i++)
		     charmap[y0][i+begin+1]=wb[i];
		    charmap[y][x]='D';
		    return true;
		  }
		}
		for(int k=1;k<size;k++)
		{
			if(k%2==0) begin=x-size/2+k/2;
			else  begin=x-size/2-k/2;
			if(begin>=0 && begin+size+2<radius*2)
			{
			   int a=0;
			   for(int i=0;i<size+2;i++)
			     if(charmap[y0][i+begin]==0)a++;
			     else break;
			
			  if(a==size+2)	
			  {
			    for(int i=0;i<size;i++)
			     charmap[y0][i+begin+1]=wb[i];
			    charmap[y][x]='D';
			    return true;
			  }
			}  
		}
		return false;
	}
	public String output_html() throws Exception {
		int x=radius*2+1;
		int y=radius+1;
		byte charmap[][]=new byte[y][x];
		byte colormap[][]=new byte[y][x];

		for(int j=0;j<y;j++)
		{
			   for(int i=0;i<x;i++) 
			    if(map[i][j]!=0)	   
			    {	charmap[j][i]='X';
			        colormap[j][i]=10;
			    }
		}	   
	   for(int j=0;j<y;j++)
	   {
		   for(int i=0;i<x;i++) 
		   {
			   if(map[i][j]!=0)
			   {
				   WamCNode n=(WamCNode) datalist.get(map[i][j]-1);
				   byte wb[]=n.getWord().getBytes(Constants.GBK);
				   if(output_html_left(wb,i,j,charmap,colormap)==false)
					   if(output_html_right(wb,i,j,charmap,colormap)==false)
					   if(output_html_top(wb,i,j,charmap,colormap)==false)
							   if(output_html_bottom(wb,i,j,charmap,colormap)==false)
								   output_html_none(wb,i,j,charmap,colormap);
			   }	   
		   }
		   
	   }	
	   ByteBuff bb=new ByteBuff();
	  
	   for(int j=0;j<y;j++)
		{
		    byte lastb=0;
			for(int i=0;i<x;i++) 
			{ 
				byte nowb=colormap[j][i];
				if(nowb!=lastb)
				{
					if(lastb==10)bb.append("</span>");
					if(lastb!=0)
						 bb.append("</font>");
					switch(nowb)
					{
					  case 1: bb.append("<font style=\"color:Blue\">");break;
					  case 3: bb.append("<font style=\"color:Green\">");break;
					  case 5: bb.append("<font style=\"color:Cyan\">");break;
					  case 7: bb.append("<font style=\"color:Magenta\">");break;
					  case 10: bb.append("<font style=\"color:RED\">");
					          bb.append ("<span Title=\"");
					          WamCNode n=(WamCNode) datalist.get(map[i][j]-1);
					          bb.append(n.getWord());
					          bb.append("\">");
					          break;
					  case 2:
					  case 4:
					  case 6:	  
					  case 8: bb.append("<font style=\"color:BLACK\">");break;
					}
					
				}	
				if(i==radius && j==radius/2)
					bb.append("<b>");
				if(charmap[j][i]==0)bb.append("&nbsp;");
				else bb.append(charmap[j][i]);
				if(i==radius && j==radius/2)
					bb.append("</b>");
				lastb=nowb;
			}
			   if(lastb==10)bb.append("</span>");
			   if(lastb!=0)
					 bb.append("</font>");
			   bb.append("<br>\n");   
		}	
	
	  
	   return bb.toString(Constants.GBK);
	}

	private void output_html_none(byte[] wb, int i, int j, byte[][] charmap,byte[][] colormap)
	{
		
		
	}

	private boolean output_html_left (byte[] wb, int x, int y, byte[][] charmap,byte[][] colormap) 
	{
		
		int size=wb.length;
	
		
		if(x<size) return false;
		int a=0;
		for(int i=x-size;i<x;i++)
		  a+=(charmap[y][i]==0)?0:1;
		if(a>0)		return false;
		for(int i=0;i<size;i++)
		{  charmap[y][i+x-size]=wb[i];
		   colormap[y][i+x-size]=1;
		}
		charmap[y][x]='L';
		colormap[y][x]=2;
		return true;
	}

	private boolean output_html_right(byte[] wb, int x, int y, byte[][] charmap,byte[][] colormap) {
		int size=wb.length;
		
		if(x+size>=radius*2) return false;
		int a=0;
		for(int i=x+1;i<x+size+1;i++)
		  a+=(charmap[y][i]==0)?0:1;
		if(a>0)		return false;
		for(int i=0;i<size;i++)
		{  charmap[y][i+x+1]=wb[i];
			colormap[y][i+x+1]=3;
		}
		charmap[y][x]='R';
		colormap[y][x]=4;
		return true;
	}

	private boolean output_html_top(byte[] wb, int x, int y, byte[][] charmap,byte[][] colormap) {
		int size=wb.length;
		
		if(y==0) return false;
		int y0=y-1;
		
		int begin=x-size/2;
		
		if(begin>=0 && begin+size+2<radius*2)
		{
		   int a=0;
		   for(int i=0;i<size+2;i++)
		     if(charmap[y0][i+begin]==0)a++;
		     else break;
		
		  if(a==size+2)	
		  {
		    for(int i=0;i<size;i++)
		    { charmap[y0][i+begin+1]=wb[i];
		    colormap[y0][i+begin+1]=5;
		    }
		    charmap[y][x]='U';
		    colormap[y][x]=6;
		    return true;
		  }
		}
		
		for(int k=1;k<size;k++)
		{
			if(k%2==0) begin=x-size/2+k/2;
			else  begin=x-size/2-k/2;
			if(begin>=0 && begin+size+2<radius*2)
			{
			   int a=0;
			   for(int i=0;i<size+2;i++)
			     if(charmap[y0][i+begin]==0)a++;
			     else break;
			
			  if(a==size+2)	
			  {
			    for(int i=0;i<size;i++)
			    { charmap[y0][i+begin+1]=wb[i];
			    colormap[y0][i+begin+1]=5;
			    }
			    charmap[y][x]='U';
			    colormap[y][x]=6;
			    return true;
			  }
			}  
		}
		
		return false;
	}

	private boolean output_html_bottom(byte[] wb, int x, int y, byte[][] charmap,byte[][] colormap)
	{
	int size=wb.length;
		
		if(y==radius) return false;
		int y0=y+1;
		
		int begin=x-size/2;
		
		if(begin>=0 && begin+size+2<radius*2)
		{
		   int a=0;
		   for(int i=0;i<size+2;i++)
		     if(charmap[y0][i+begin]==0)a++;
		     else break;
		
		  if(a==size+2)	
		  {
		    for(int i=0;i<size;i++)
		    { charmap[y0][i+begin+1]=wb[i];
		      colormap[y0][i+begin+1]=7; 
		    }
		    charmap[y][x]='D';
		    colormap[y][x]=8;
		    return true;
		  }
		}
		for(int k=1;k<size;k++)
		{
			if(k%2==0) begin=x-size/2+k/2;
			else  begin=x-size/2-k/2;
			if(begin>=0 && begin+size+2<radius*2)
			{
			   int a=0;
			   for(int i=0;i<size+2;i++)
			     if(charmap[y0][i+begin]==0)a++;
			     else break;
			
			  if(a==size+2)	
			  {
			    for(int i=0;i<size;i++)
			    { charmap[y0][i+begin+1]=wb[i];
			      colormap[y0][i+begin+1]=7;
			    }
			    charmap[y][x]='D';
			    colormap[y][x]=8;
			    return true;
			  }
			}  
		}
		return false;
	}
}
