package cn.sowjz.search.core.query.draw;

import java.util.ArrayList;
import java.util.List;

import cn.sowjz.search.core.query.response.DmkWord;
import cn.sowjz.search.core.query.response.WamResponse;

public class WamCalculator
{

	int validnum;
	int valid[];
	List<WamCNode> result;
	
	WamCNode root;
	int nodenum;
	
	WamResponse hits;

	public void fillIn(WamResponse hits,String []stopwords)
	{
		this.hits=hits;
		
		validCheck(hits,stopwords);	
	    if(validnum==0)  return ;
	    if(validnum==1)
	    {
	    	result=new ArrayList<WamCNode>(1);
	    	DmkWord w=hits.getWord(valid[0]);
	    	result.add(new WamCNode(w,valid[0]));
	    	return ;
	    } 	
	    
	    
	    
	    
	    root=new WamCNode(hits.getWord(valid[0]),valid[0]);

	    WamCNode n2= new WamCNode(hits.getWord(valid[1]),valid[1]);
        n2.putInDown(root, 0);
	    
	    nodenum=2; 
	    if(nodenum==validnum) {	buildResult();	return;  } 	
	    
	    
	    for(int i=2;i<validnum;i++)
	    {	    	
	    	firstLoopAddNode(valid[i]);
	    	nodenum++;
	    }	
	    
	    calcAngle();
 //printAllNode();
	    
	    buildResult();
	}

	

	private void  validCheck(WamResponse hits, String[] stopwords) 
	{
		valid=new int[hits.getWordnum()];
		validnum=0;
		for(int i=0;i<hits.getWordnum();i++)
		{
			DmkWord w=hits.getWord(i);
			boolean found=false;
			if(stopwords!=null)
			for(int j=0;j<stopwords.length;j++)
			{
				if(w.getWord().equalsIgnoreCase(stopwords[j]))
				{	found=true; break;}
			}	
			if(!found)
			{
				valid[validnum]=i;
				validnum++;
			}	
		}
	}

	public void printAllNode()
	{
		List<WamCNode> l=new ArrayList<WamCNode>(nodenum);
		root.putIntoList(l);
		
		for(int i=0;i<nodenum;i++)
		{
			WamCNode n=l.get(i);
			n.print();
		}	
	}

	private void firstLoopAddNode( int seq) 
	{
		int maxmark=0;
		WamCNode shouldn=root;
		int secondMM=0;
		WamCNode secondSN=root;
		
		List<WamCNode> l=new ArrayList<WamCNode>(nodenum);
		root.putIntoList(l);
		
		boolean downdir=true;
		for(int i=0;i<nodenum;i++)
		{
			WamCNode n=l.get(i);
			
			int mark1=hits.getMatrixValue(n.seq, seq);
			if(mark1>maxmark)
			{
				secondMM=maxmark;
				secondSN=shouldn;
				maxmark=mark1;
				shouldn=n;
				downdir=false;
			}else if(mark1>secondMM)
			{
				secondMM=mark1;
				secondSN=n;
				downdir=true;
			}	
			
		}	
		
		int cm=hits.getMatrixValue(shouldn.seq, secondSN.seq);
		
		if(cm<secondMM ) downdir=!downdir;
			
		if(downdir)
		{
			if(shouldn.downcnum==0)
			{	new WamCNode(hits.getWord(seq),seq).putInDown(shouldn, 0);
			   return;
			}
			for(int i=0;i<shouldn.down.size();i++)
			{
				WamCNode n=shouldn.down.get(i);
				int m1=hits.getMatrixValue(shouldn.seq, n.seq);
				if(maxmark>m1)
				{	new WamCNode(hits.getWord(seq),seq).putInDown(shouldn, i);
				    return;
				}
			}	
			new WamCNode(hits.getWord(seq),seq).putInDown(shouldn, shouldn.downcnum);
			return;
		}	
		if(shouldn.upcnum==0)
		{	new WamCNode(hits.getWord(seq),seq).putInUp(shouldn, 0);
		   return;
		}
		for(int i=0;i<shouldn.up.size();i++)
		{
			WamCNode n=shouldn.up.get(i);
			int m1=hits.getMatrixValue(shouldn.seq, n.seq);
			if(maxmark>m1)
			{	new WamCNode(hits.getWord(seq),seq).putInUp(shouldn, i);
			    return;
			}
		}	
		new WamCNode(hits.getWord(seq),seq).putInUp(shouldn, shouldn.upcnum);
		return;
		
	}


	private void calcAngle() {
		//根据root孩子之间的距离计算角度。
	    //第一个孩子下，与下一个孩子上构成一组加上2端孩子计算角度。
		//半径为，与root的mark比
				
		root.radius=0;
		root.angle=0;
		
		int rsn=root.upcnum+root.downcnum;
		if(rsn==0)return;
		
		WamCNode subs[]=root.allChildArray();
		int sn=subs.length;
		if(sn==1)
		{
			
			WamCNode n=subs[0];
			n.radius=((double)root.word.getMark()/n.word.getMark());
			n.angle=0;
				
		}else
		{
			
		    double d[]=new double[sn];
		    double sumd=0;
		    for(int i=0;i<sn;i++)
		    {
		    	int j=(i+1)%sn;
		    	d[i]=Math.log( 10001/(1+hits.getMatrixValue(subs[i].seq, subs[j].seq)));
		    	sumd+=d[i];
//System.out.println(" d["+i+"]="+d[i]);
		    }	
		    double ad=0;
		    //int totala=(rsn==1)? 160:360;
		    int totala=360;
		    for(int i=0;i<sn;i++)
		    {
		    	WamCNode n=subs[i];
		    	n.radius=((double)root.word.getMark()/n.word.getMark());
		     
				n.angle=totala*ad/sumd;
				ad+=d[i];
		    } 
		}	

		
	}

	private void buildResult() 
	{
		result=new ArrayList<WamCNode>(validnum);
		root.putIntoList(result);
	}



	public List<WamCNode> getResult() {
		return result;
	}


	public WamCNode getRootNode()
	{
		return root;
	}
}
