package cn.sowjz.search.core.query.draw;

import java.util.ArrayList;
import java.util.List;

import cn.sowjz.search.core.query.response.DmkWord;


public class WamCNode 
{

	List<WamCNode> up;
	List<WamCNode> down;
	DmkWord  word;
	int seq;
	

	WamCNode parent;
	boolean downparent;
	int upcnum;
	int downcnum;
	
	
	double radius;
	double angle;
	
	public WamCNode(DmkWord  w,int s)
	{
		seq=s;
		word=w;
		up=null;
		down=null;
		upcnum=0;
		downcnum=0;
	}

	public void putInDown(WamCNode n,int p ) 
	{
		
		 parent=n;
		 downparent=true;;
		parent.downcnum++;
        
		if(n.down==null)
		{
			n.down=new  ArrayList <WamCNode>();
			n.down.add(this);
		}	
		else
	      n.down.add(p, this);
	}
	public void putInUp(WamCNode n,int p) 
	{
		
		 parent=n;
		 downparent=false;;
		parent.upcnum++;
        
		if(n.up==null)
		{
			n.up=new ArrayList<WamCNode>();
			n.up.add(this);
		}	
		else
	      n.up.add(p, this);
	}	
	


	public void putIntoList(List<WamCNode> alist)
	{
		if(up!=null)
			for(int i=up.size()-1;i>=0;i--)
			   up.get(i).putIntoList(alist);
		alist.add(this);
		if(down!=null)
			for(int i=0;i<down.size();i++)
				down.get(i).putIntoList(alist);
	}

	public void print() 
	{
		System.out.println(toString());
		
	}

	public String toString()
	{
		return "seq="+seq+" "+word +" parent="+(((parent==null)?"null":parent.word.getWord()) +" r="+radius+" angle="+angle);
	}
	
	public WamCNode[] childArray()
	{
		int n=upcnum+downcnum;
		if(n==0)return null;
		
		WamCNode[] cn=new WamCNode[n];
		
		int m=0;
		
		if(up!=null)
			for(int i=0;i<up.size();i++)
				cn[m++]=up.get(i);
		
		if(down!=null)
			for(int i=0;i<down.size();i++)
				cn[m++]=down.get(i);
		
		for(int i=0;i<m-1;i++)
			for(int j=i+1;j<m;j++)
			{
				if(cn[i].getMark()<cn[j].getMark())
				{
					WamCNode t=cn[i];
					cn[i]=cn[j];
					cn[j]=t;
				}	
			}	
		return cn;
	}
	public WamCNode[] allChildArray()
	{
		int n=upcnum+downcnum;
		if(n==0)return null;
		
		List<WamCNode> alist=new ArrayList<WamCNode>();
		if(up!=null)
			for(int i=up.size()-1;i>=0;i--)
			   up.get(i).putIntoList(alist);
		
		if(down!=null)
			for(int i=0;i<down.size();i++)
				down.get(i).putIntoList(alist);
		
		WamCNode[] ns=new WamCNode[alist.size()];
		for(int i=0;i<alist.size();i++)
			ns[i]=alist.get(i);
		return ns;
	}
	public static void main(String [] argv)throws Exception
	{
		List<String> l=new ArrayList<String>();
		l.add("abc1");l.add("abc2");l.add("abc3");
		for(int i=0;i<l.size();i++)
			System.out.println(l.get(i));
		l.add(0, "cde");
		for(int i=0;i<l.size();i++)
			System.out.println(l.get(i));
	}

	public String getWord() {
		return word.getWord();
	}
	public int getDocnum() {
		return word.getDocnum();
	}

	public double getIdf() {
		return word.getIdf();
	}

	public int getMark() {
		return word.getMark();
	}
	public WamCNode getParent() {
		return parent;
	}

	public double getRadius() {
		return radius;
	}

	public double getAngle() {
		return angle;
	}

}
