package cn.sowjz.search.core.net.sock;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

import cn.sowjz.search.core.Constants;

/**
 * 此类实现服务器套接字。服务器套接字等待请求通过网络传入。它基于该请求执行某些操作，然后可能向请求者返回结果。默认的网络传输字符集为GBK
 * @author Ryan
 * @since 1.0
 * @version 1.1
 * @date 2007-4-28
 */
class MServerSocket
{
	private ServerSocket ss;

	private int port;

	private String charset;
	private int timeout;

	/**
	 * 构造
	 * @throws IOException
	 */
	public MServerSocket(int timeout) throws IOException
	{
		charset = Constants.GBK;
		ss = new ServerSocket();
		this.timeout=timeout;
	}

	/**
	 * 构造
	 * @param port -- 段口号
	 * @throws IOException
	 */
	public MServerSocket(int port,int timeout) throws IOException
	{
		this(port, timeout,Constants.GBK);
	}

	/**
	 * 构造
	 * @param port -- 段口号
	 * @param charset -- 网络传输的字符集
	 * @throws IOException
	 */
	public MServerSocket(int port,int timeout, String charset) throws IOException
	{
		this.charset = charset;
		this.timeout=timeout;
		ss = new ServerSocket(port);
	}

	/**
	 * 返回网络传输字符集
	 * @return
	 */
	public String getCharset()
	{
		return charset;
	}

	/**
	 * 设置网络传输字符集
	 * @param charset -- 网络传输字符集
	 */
	public void setCharset(String charset)
	{
		this.charset = charset;
	}

	/**
	 * 得到侦听段口号
	 * @return
	 */
	public int getPort()
	{
		return port;
	}

	/**
	 * 设置侦听段口号
	 * @param port
	 */
	public void setPort(int port)
	{
		this.port = port;
	}

	/**
	 * 侦听并接受到此套接字的连接。此方法在进行连接之前一直阻塞
	 * @return
	 * @throws IOException
	 */
	public MSocket accept() throws IOException
	{
		Socket sock = ss.accept();
		MSocket mySock = new MSocket(timeout);
		mySock.setSocket(sock);
		mySock.setCharset(charset);
		return mySock;
	}

	/**
	 * 关闭此套接字。 如果此套接字有一个与之关联的通道，则关闭该通道。
	 */
	public void close()
	{
		if (ss != null)
		{
			try
			{
				ss.close();
			} catch (IOException e)
			{
				// ignore
			} finally
			{
				if (ss != null)
					ss = null;
			}
		}
	}
/*
	public static void main(String[] args) throws IOException
	{
		MyServerSocket mss = new MyServerSocket(5153, "GB2312");
		System.out.println("开始监听.....");
		MySocket ms = mss.accept();
		System.out.println("得到连接...");
		System.out.printf("IP: %s\nPort: %d", ms.getIp(), ms.getPort());

		// 下面的自己写,即:发送,接收等等.参考MySocket里面的方法
		ms.send((byte) 1);
		ms.send((short) 2);
		ms.send(1234);
		ms.send(9999L);
		ms.send("我的问题。在MySocket的setSocket方法中出了问题。");
		System.out.println("client byte: " + ms.recvByte());
		System.out.println("client short: " + ms.recvShort());
		System.out.println("client int: " + ms.recvInt());
		System.out.println("client long:" + ms.recvLong());
		System.out.println("client string:" + ms.recvStr());

		ms.close();
		mss.close();
	}
*/	
}
