package cn.sowjz.search.core.net.pool;

import cn.sowjz.search.core.conf.SearchConfig;
import cn.sowjz.search.core.net.control.BaseConn;

public class NoPool<T extends BaseConn> implements ConnPool<T>{

	ConnBuilder<T> builder;
	public NoPool(ConnBuilder<T> builder)
	{
		this.builder=builder;
	}
	
	SearchConfig conf;
	@Override
	public void initialize(SearchConfig conf) throws Exception {
		this.conf=conf;
	}

	@Override
	public T getConn() throws Exception {
		T c= builder.createConn(conf);
		return c;
	}

	@Override
	public void releaseConn(T conn) throws Exception {
		conn.close();
	}

	@Override
	public void destroy() {
		
		
	}

	@Override
	public void pulse() {
		
		
	}

	@Override
	public void releaseConn(T conn, Exception e) throws Exception {		
		releaseConn(conn);
	}


	@Override
	public void setBuilder(ConnBuilder<T> builder) {
		this.builder = builder;
	}

}
