package cn.sowjz.search.core.net.pool;

import cn.sowjz.search.core.conf.SearchConfig;
import cn.sowjz.search.core.net.control.BaseConn;

public interface ConnPool<T extends BaseConn> {
	
	public void initialize(SearchConfig conf)throws Exception;
	public T getConn()throws Exception;
	public void releaseConn(T conn)throws Exception;
	public void releaseConn(T conn,Exception e)throws Exception;
	public void destroy();
	public void pulse();
	public void setBuilder(ConnBuilder<T> builder) ;
}
