package cn.sowjz.search.core.net.control;

/**
 * 操作时的一些变量
 * @author Ryan
 * @version 1.1
 * @since 1.0
 * @date 2007-4-23
 */
public class ControlerVariable
{
	/**
	 * 操作成功
	 */
	public static final int SUCCESS = 0;

	/**
	 * 服务器繁忙，比方说：服务器正在加载数据。
	 */
	public static final int ERR_BUSY = 1;

	/**
	 * 全文库已经存在
	 */
	public static final int ERR_DB_EXIST = 2;

	/**
	 * 全文库不存在
	 */
	public static final int ERR_DB_NOT_EXIST = 3;

	/**
	 * segment不存在
	 */
	public static final int ERR_SEG_NOT_EXIST = 4;

	/**
	 * 文章不存在
	 */
	public static final int ERR_DOC_NOT_EXIST = 5;

	/**
	 * 全文库IO错误
	 */
	public static final int ERR_DB_IO = 6;

	/**
	 * 未知错误
	 */
	public static final int ERR_UNKNOW = 7;

	/**
	 * 非法操作
	 */
	public static final int ERR_OPERATION_NO = 8;

	/**
	 * 内存错误
	 */
	public static final int ERR_MEMORY = 9;

	/**
	 * sql指令错误
	 */
	public static final int ERR_SQL = 10;

	/**
	 * 检索错误
	 */
	public static final int ERR_QUERY = 11;

	/**
	 * 文章id错误
	 */
	public static final int ERR_NO_DOC = 12;

	/**
	 * 删除错误
	 */
	public static final int ERR_DEL = 14;

	/**
	 * 服务器加载出现问题，不允许再进行加载
	 */
	public static final int ERR_IDX_CANNOT = 15;

	/**
	 * segment不存在
	 */
	public static final int ERR_NO_REG = 16;

	/**
	 * 统计错误
	 */
	public static final int ERR_COUNT = 17;
	
	//数组越界
	public static final int ERR_ARRAY_INDEX_OUTOF_BOUNDS =18;

	// ///////////////////////////////////////////////////////////////
	
	public static final int EXAMINE = 96;
	/**
	 * 查询注册信息
	 */
	public static final int REG_INFO_QUERY = 97;

	/**
	 * 检测是否能够正常加载
	 */
	public static final int ADD_INDEX_TEST = 98;

	/**
	 * 检测连接是否正常
	 */
	public static final int CONNECTION_TEST = 99;

	/**
	 * 创建库操作
	 */
	public static final int DB_CREATE = 100;

	/**
	 * 删除库操作
	 */
	public static final int DB_DROP = 101; // reserve

	/**
	 * 查询库结构
	 */
	public static final int DB_DESC = 102;

	/**
	 * 删除segment操作
	 */
	public static final int EMPTY = 103; // reserve

	public static final int EMPTY_TABLE = 104; // reserve

	/**
	 * 本地加载文章操作
	 */
	public static final int DOC_ADD_LOCAL = 105;

	/**
	 * 远程加载文章操作
	 */
	public static final int DOC_ADD_REMOTE = 106; // reserve
	
	public static final int DOC_ADD_TO_TABLE = 107; 
	
	/**对fsearch远程加载
	 * */
	public static final int ZIPED_DOC_ADD_REMOTE = 108; 




	/**
	 * 检索文章操作
	 */
	public static final int DOC_SEARCH = 109;

	/**
	 * 提交操作
	 */
	public static final int COMMIT = 110;

	/**
	 * 停止服务端操作
	 */
	public static final int STOP_SERVER = 111;


	/**
	 * 查询检索系统ID的范围
	 * */
	public static final int DB_SEQ_SCOPE	=	112; 
	
	
	/**
	 * 删除文章操作
	 */
	public static final int DOC_DEL = 113;

	/**
	 * 查询全文库配置信息操作
	 */
	public static final int DB_CONF_QUERY = 114;

	/**
	 * 查询全文库索引文件合并配置
	 */
	public static final int MERGER_CONF_QUERY = 115;

	/**
	 * 查询全库库索引文件写配置
	 */
	public static final int WRITER_CONF_QUERY = 116;

	/**
	 * 查询服务端日至配置
	 */
	public static final int LOGGER_CONF_QUERY = 117;

	/**
	 * 查询全文库segment管理配置
	 */
	public static final int SEG_MANAGER_CONF_QUERY = 118;

	/**
	 * 查询全文库索引读配置
	 */
	public static final int QUERY_PROCESS_CONF_QUERY = 119;

	/**
	 * 查询服务端的通讯配置
	 */
	public static final int NET_CONF_QUERY = 120;

	/**
	 * 不分组统计操作
	 */
	public static final int COUNT_NOT_GROUP = 121;

	/**
	 * 分组统计操作
	 */
	public static final int COUNT_GROUP = 122;
	public static final int COUNT_CUBE = 124;
	
	public static final int MAX_FEED_SIZE = 125;
	
	public static final int ICTRL_DISTINCT_SELECTALL	=	140;
	
	public static final int MINING_TOKEN=150;
	public static final int MINING_FINGER_PRINT=151;
	public static final int MINING_FINGER_PRINT_SIMHASH=152;
	public static final int MINING_SUMMARY=153;
	public static final int MINING_SUMMARY_QUERY=154;
	
	public static final int UNITED_QUERY=160;
	
	public static final int ASYN_QUERY_STATUS		=170;
	public static final int ASYN_QUERY_BEGIN		=171;
	public static final int ASYN_QUERY_RESULT		=178;
	public static final int ASYN_QUERY_STOP			=179;
	
	public static final int UPDATE_Doc=180;
	/**
	 * 应答信号量
	 */
	public static final int ACK = 211;
	public static final int LOOPACK = 212;


	
	public static final int OPT_DATAMINING_KEYWORDS = 130;
	public static final int OPT_DATAMINING_WORDClOUD = 131;
	public static final int OPT_DATAMINING_WAM= 132;
	public static final int OPT_DATAMINING_CLUSTER= 133;
	
	public static final int OPT_TABLE_CREATE	=				200;
	public static final int OPT_TABLE_DROP		=				201 ;
	public static final int OPT_TABLE_ACCESS	=				202 ;
	public static final int OPT_TABLE_LOAD		=				203 ;
	public static final int OPT_TABLE_UNLOAD	=				204 ;
	public static final int OPT_TABLE_NAMES		=				205 ;
	
	public static final int OPT_PRISM_EDIT_MODE=300;
	public static final int OPT_PRISM_WORK_MODE=301;
	public static final int OPT_PRISM_CLEAR_QUERY=302;
	public static final int OPT_PRISM_ADD_QUERY=303;
	public static final int OPT_PRISM_DOC_RUN=304;
	public static final int OPT_PRISM_DOC_LIST_RUN=305;
	public static final int OPT_PRISM_ADD_QUERY_WITH_ID=306;
	public static final int OPT_PRISM_WORD_CLOUD=310;
}
