package cn.sowjz.search.core.net.control;

import java.util.ArrayList;
import java.util.List;

import cn.sowjz.search.common.ByteBuff;
import cn.sowjz.search.common.VConvert;
import cn.sowjz.search.core.SearchClient;
import cn.sowjz.search.core.db.Schema;
import cn.sowjz.search.core.doc.Doc;
import cn.sowjz.search.core.query.request.BaseRequest;
import cn.sowjz.search.core.query.request.ClusterRequest;
import cn.sowjz.search.core.query.request.CubeRequest;
import cn.sowjz.search.core.query.request.DistinctRequest;
import cn.sowjz.search.core.query.request.GroupRequest;
import cn.sowjz.search.core.query.request.KeyWordRequest;
import cn.sowjz.search.core.query.request.QueryRequest;
import cn.sowjz.search.core.query.request.UnitedRequest;
import cn.sowjz.search.core.query.request.WamRequest;
import cn.sowjz.search.core.query.request.WordCloudRequest;
import cn.sowjz.search.core.query.response.AsynInfo;
import cn.sowjz.search.core.query.response.ClusterResponse;
import cn.sowjz.search.core.query.response.CubeResponse;
import cn.sowjz.search.core.query.response.DbSeqScope;
import cn.sowjz.search.core.query.response.DistinctResponse;
import cn.sowjz.search.core.query.response.ExamineResponse;
import cn.sowjz.search.core.query.response.GroupResponse;
import cn.sowjz.search.core.query.response.QueryResponse;
import cn.sowjz.search.core.query.response.UnitedResponse;
import cn.sowjz.search.core.query.response.UpdateResponse;
import cn.sowjz.search.core.query.response.WamResponse;
import cn.sowjz.search.core.query.response.WordCloudResponse;
import cn.sowjz.search.core.server.state.ServerFeedInfo;
import cn.sowjz.search.core.server.state.ServerIdxThreadStates;
import cn.sowjz.search.core.server.state.ServerRegisterState;

public class AskQuery {
	
	BaseConn conn;
	
	public AskQuery(BaseConn conn)
	{
		this.conn=conn;
	}
	/*
	public AskQuery(Configuration cfg)
	{
		super(cfg.getSockIp(),cfg.getQuerySockPort(),cfg.getSocketTimeOut());
	}
*/
	public ServerFeedInfo feedInfo()throws Exception 
	{
		
		byte [] buf=conn.runCommand(ControlerVariable.MAX_FEED_SIZE);
		if(buf==null)return null;
		
		ServerFeedInfo sfi=new ServerFeedInfo();
		sfi.byte2Me(buf,0,buf.length);
		
		return sfi;		
	}

	public boolean testConnection()throws Exception  {
		return conn.runCommand(ControlerVariable.CONNECTION_TEST)!=null;		
	}

	public Schema descDb(String charset)throws Exception 
	{
		byte [] buf=conn.runCommand(ControlerVariable.DB_DESC);
		if(buf==null)return null;
		return Schema.bytes2Me(buf, charset);
		
	}

	public ServerIdxThreadStates testAddIndex(Schema schema,String charset) throws Exception 
	{
		byte [] buf=conn.runCommand(ControlerVariable.ADD_INDEX_TEST);
		if(buf==null)return null;
		ServerIdxThreadStates states = new ServerIdxThreadStates(schema);
		states.bytes2Me(buf, charset);
		return states;
	}

	public ServerRegisterState queryRegisterState(String charset) throws Exception  {
		byte [] buf=conn.runCommand(ControlerVariable.REG_INFO_QUERY);
		if(buf==null)return null;
		ServerRegisterState regState = new ServerRegisterState();
		regState.byte2Me(buf, 0, charset);
		return regState;
	}

	public QueryResponse query(QueryRequest req,  SearchClient searchSystem) throws Exception 
	{
		ByteBuff bb=req.toByteBuff();
		byte [] buf=conn.runCommand(ControlerVariable.DOC_SEARCH,bb.array(),bb.getUsed());
		if(buf==null)return null;
		QueryResponse hits = new QueryResponse(searchSystem);
		hits.bytes2Me(buf);
		return hits;
	}
	public DistinctResponse distinct_query(QueryRequest req,  SearchClient searchSystem) throws Exception 
	{
		ByteBuff bb=req.toByteBuff();
		byte [] buf=conn.runCommand(ControlerVariable.DOC_SEARCH,bb.array(),bb.getUsed());
		if(buf==null)return null;
		DistinctResponse hits = new DistinctResponse(searchSystem);
		hits.bytes2Me(buf);
		return hits;
	}
	public QueryResponse distinct(DistinctRequest req,  SearchClient searchSystem) throws Exception 
	{
		ByteBuff bb=req.toByteBuff();
		byte [] buf=conn.runCommand(ControlerVariable.DOC_SEARCH,bb.array(),bb.getUsed());
		if(buf==null)return null;
		QueryResponse hits = new QueryResponse(searchSystem);
		hits.bytes2Me(buf);
		return hits;
	}
	public QueryResponse collectKeyWords(KeyWordRequest req, 	SearchClient searchSystem) throws Exception 
	{
		ByteBuff bb=req.toByteBuff();
		byte [] buf=conn.runCommand(ControlerVariable.OPT_DATAMINING_KEYWORDS,bb.array(),bb.getUsed());
		if(buf==null)return null;
		QueryResponse hits = new QueryResponse(searchSystem);
		hits.bytes2Me(buf);
		return hits;
	}


	public long count(BaseRequest req) throws Exception 
	{
		ByteBuff bb=req.toByteBuff();
		byte [] buf=conn.runCommand(ControlerVariable.COUNT_NOT_GROUP,bb.array(),bb.getUsed());
		if(buf==null)return -1;
		return  VConvert.bytes2Long(buf);
	}

	public GroupResponse group(GroupRequest req,  SearchClient searchSystem)throws Exception 
	{
		ByteBuff bb=req.toByteBuff();
		byte [] buf=conn.runCommand(ControlerVariable.COUNT_GROUP,bb.array(),bb.getUsed());
		if(buf==null)return null;
		GroupResponse hits = new GroupResponse(searchSystem);
		hits.byte2Me(buf);
		return hits;
	}

	public CubeResponse cube(CubeRequest req,  SearchClient searchSystem) throws Exception 
	{
		ByteBuff bb=req.toByteBuff();
		byte [] buf=conn.runCommand(ControlerVariable.COUNT_CUBE,bb.array(),bb.getUsed());
		if(buf==null)return null;
		CubeResponse hits = new CubeResponse(searchSystem);
		hits.byte2Me(buf);

		return hits;
	}

	public int removeDoc(BaseRequest req) throws Exception 
	{
		ByteBuff bb=req.toByteBuff();
		byte [] buf=conn.runCommand(ControlerVariable.DOC_DEL,bb.array(),bb.getUsed());
		if(buf==null)return -1;
		return VConvert.bytes2Int(buf);
	}

	public void stopServer() throws Exception 
	{
		conn.runCommand(ControlerVariable.STOP_SERVER);
		
	}

	public WordCloudResponse wordCould(WordCloudRequest req,SearchClient searchSystem) throws Exception {
		ByteBuff bb=req.toByteBuff();
		byte [] buf=conn.runCommand(ControlerVariable.OPT_DATAMINING_WORDClOUD,bb.array(),bb.getUsed());
		if(buf==null)return null;
		WordCloudResponse hits = new WordCloudResponse(searchSystem);
		hits.bytes2Me(buf);
		return hits;
	}

	public WamResponse wordAssoociateMap(WamRequest req,SearchClient searchSystem)throws Exception {
		ByteBuff bb=req.toByteBuff();
		byte [] buf=conn.runCommand(ControlerVariable.OPT_DATAMINING_WAM,bb.array(),bb.getUsed());
		if(buf==null)return null;
		WamResponse hits = new WamResponse(searchSystem);
		hits.byte2Me(buf);
		return hits;
	}

	public ClusterResponse cluster(ClusterRequest req,SearchClient searchSystem) throws Exception {
		ByteBuff bb=req.toByteBuff();
		byte [] buf=conn.runCommand(ControlerVariable.OPT_DATAMINING_CLUSTER,bb.array(),bb.getUsed());
		if(buf==null)return null;
		ClusterResponse hits = new ClusterResponse(searchSystem);
		hits.byte2Me(buf);
		return hits;
	}
	public UpdateResponse update(BaseRequest req, Doc doc, SearchClient searchSystem) throws Exception {
		ByteBuff bb=req.toByteBuff();
		ByteBuff ab=doc.toByteBuff4update();
		byte [] buf=conn.runCommand(ControlerVariable.UPDATE_Doc,bb.array(),bb.getUsed(),ab.array(),ab.getUsed());
		if(buf==null)return null;
		UpdateResponse r=new UpdateResponse();
		r.byte2Me(buf);
		return  r;
	}
	public QueryResponse ictrlDistinctSelectAll(QueryRequest req,  SearchClient searchSystem) throws Exception 
	{
		ByteBuff bb=req.toByteBuff();
		byte [] buf=conn.runCommand(ControlerVariable.ICTRL_DISTINCT_SELECTALL,bb.array(),bb.getUsed());
		if(buf==null)return null;
		QueryResponse hits = new QueryResponse(searchSystem);
		hits.bytes2Me(buf);
		return hits;
	}
	public DbSeqScope querySeqScope() throws Exception {
		byte [] buf=conn.runCommand(ControlerVariable.DB_SEQ_SCOPE);
		if(buf==null)return null;
		DbSeqScope scope = new DbSeqScope();
		scope.bytes2Me(buf);
		return scope;
	}
	public UnitedResponse unitedQuery(UnitedRequest req, SearchClient searchSystem) throws Exception {
		ByteBuff bb=req.toByteBuff();
		byte [] buf=conn.runCommand(ControlerVariable.UNITED_QUERY,bb.array(),bb.getUsed());
		if(buf==null)return null;
		UnitedResponse hits = new UnitedResponse(searchSystem);
		hits.bytes2Me(buf);
		return hits;
	}
	public ExamineResponse examine(QueryRequest req, SearchClient searchSystem) throws Exception {
		ByteBuff bb=req.toByteBuff();
		byte [] buf=conn.runCommand(ControlerVariable.EXAMINE,bb.array(),bb.getUsed());
		if(buf==null)return null;
		ExamineResponse hits = new ExamineResponse(searchSystem,req);
		hits.bytes2Me(buf);
		return hits;
	}
	public boolean accessTable(String table_name) throws Exception {
		
		
		ByteBuff bb=new ByteBuff();
		bb.append(table_name);
		bb.append((byte)0);
		
		byte [] buf= conn.runCommand(ControlerVariable.OPT_TABLE_ACCESS,bb.array(),bb.getUsed());
		if(buf==null)
			throw new Exception(conn.getErrMsg());
		int r=VConvert.bytes2Int(buf);
		if(r==0) return true;
		return false;
	}
	public List<String> readTableNames() throws Exception {
		byte [] buf= conn.runCommand(ControlerVariable.OPT_TABLE_NAMES);
		if(buf==null)
			throw new Exception(conn.getErrMsg());
		
		
		String charset = "ISO8859-1";
		
		int start=0;
		int size = VConvert.bytes2Int(buf, start);
		start += 4;
		List<String> names=new ArrayList<String>(size);
		
		for(int i=0;i<size;i++)
		{
			int len = VConvert.bytes2Int(buf, start);
			start += 4;
			String name= new String(buf, start, len - 1, charset);
			start += len;
			
			names.add(name);
		}	
		
		return names;
	}
	public AsynInfo asynQueryBegin(int id, UnitedRequest req) throws Exception {
		ByteBuff bb=new ByteBuff();
		bb.append(id);
		bb.append(req.toByteBuff());
		byte [] buf= conn.runCommand(ControlerVariable.ASYN_QUERY_BEGIN,bb.array(),bb.getUsed());
		if(buf==null)
			throw new Exception(conn.getErrMsg());
		
		AsynInfo ai=new AsynInfo();
		ai.bytes2Me(buf);
		return ai;
	}
	public AsynInfo asynQueryStop(int id) throws Exception {
		ByteBuff bb=new ByteBuff();
		bb.append(id);
		byte [] buf= conn.runCommand(ControlerVariable.ASYN_QUERY_STOP,bb.array(),bb.getUsed());
		if(buf==null)
			throw new Exception(conn.getErrMsg());
		
		AsynInfo ai=new AsynInfo();
		ai.bytes2Me(buf);
		return ai;
	}
	public AsynInfo asynQueryResult(int id, SearchClient client) throws Exception {
		ByteBuff bb=new ByteBuff();
		bb.append(id);
		byte [] buf= conn.runCommand(ControlerVariable.ASYN_QUERY_RESULT,bb.array(),bb.getUsed());
		if(buf==null)
			throw new Exception(conn.getErrMsg());
		
		AsynInfo ai=new AsynInfo(client);
		ai.bytes2Me(buf);
		return ai;
	}
	public AsynInfo asynQueryStatus() throws Exception {
		byte [] buf= conn.runCommand(ControlerVariable.ASYN_QUERY_STATUS);
		if(buf==null)
			throw new Exception(conn.getErrMsg());
		
		AsynInfo ai=new AsynInfo();
		ai.bytes2Me(buf);
		return ai;
	}
}
