package cn.sowjz.search.core.net.control;

import java.util.ArrayList;
import java.util.List;

import cn.sowjz.search.common.ByteBuff;
import cn.sowjz.search.common.VConvert;
import cn.sowjz.search.core.SearchClient;
import cn.sowjz.search.core.query.request.QueryRequest;
import cn.sowjz.search.core.query.response.SummaryResponse;
import cn.sowjz.search.core.query.response.XWord;

public class AskMining {
	
	BaseConn conn;
	
	public AskMining(BaseConn conn)
	{
		this.conn=conn;
	}
	
	 public List<XWord> tokenText(String text,String charset)throws Exception
	 {
		 byte []tb=text.getBytes(charset);
		 ByteBuff bb=new ByteBuff();
		 bb.append(tb);
		 bb.append((byte)0);
			
		 byte [] buf=conn.runCommand(ControlerVariable.MINING_TOKEN,bb.array(),bb.getUsed());
		if(buf==null)return null;	
		
			
			int start=0;
			int size = VConvert.bytes2Int(buf, start);
			start += 4;
			List<XWord> words=new ArrayList<XWord>(size);
			
			for(int i=0;i<size;i++)
			{
				XWord w = new XWord();
				start += w.byte2Me(buf, start, charset);
				words.add(w);
			}	
			
		
			return words;
	 }

	public String fingerPrint(String text, String charset)throws Exception {
		byte []tb=text.getBytes(charset);
		 ByteBuff bb=new ByteBuff();
		 bb.append(tb);
		 bb.append((byte)0);
			
		 byte [] buf=conn.runCommand(ControlerVariable.MINING_FINGER_PRINT,bb.array(),bb.getUsed());
		 if(buf==null)return null;
		return new String(buf,charset);
	}

	public byte[] fingerPrintSimhash(String text, String charset) throws Exception {
		byte []tb=text.getBytes(charset);
		 ByteBuff bb=new ByteBuff();
		 bb.append(tb);
		 bb.append((byte)0);
			
		 byte [] buf=conn.runCommand(ControlerVariable.MINING_FINGER_PRINT_SIMHASH,bb.array(),bb.getUsed());
		 if(buf==null)return null;
		return buf;
	}

	public String summary(String text, String charset, int maxline,
			boolean sentence_end_with_period) throws Exception {
		byte []tb=text.getBytes(charset);
		 ByteBuff bb=new ByteBuff();
		 bb.append(tb.length+1);
		 bb.append(tb);
		 bb.append((byte)0);
		 bb.append(maxline);
		 bb.append(sentence_end_with_period);
			
		 byte [] buf=conn.runCommand(ControlerVariable.MINING_SUMMARY,bb.array(),bb.getUsed());
		 if(buf==null)return null;
		return new String(buf,charset);
	}

	public SummaryResponse summary_query(QueryRequest req, SearchClient searchSystem) throws Exception {
		ByteBuff bb=req.toByteBuff();
		byte [] buf=conn.runCommand(ControlerVariable.MINING_SUMMARY_QUERY,bb.array(),bb.getUsed());
		if(buf==null)return null;
		SummaryResponse hits = new SummaryResponse(searchSystem,req);
		hits.bytes2Me(buf);
		return hits;
	}
}
