package cn.sowjz.search.core.net.control;

import cn.sowjz.search.common.ByteBuff;
import cn.sowjz.search.common.VConvert;
import cn.sowjz.search.common.util.GZip;
import cn.sowjz.search.core.db.Schema;

public class AskIndex {

	BaseConn conn;
	
	public AskIndex(BaseConn conn)
	{
		this.conn=conn;
	}

	public void createDb(Schema schema, String charset) throws Exception {
		ByteBuff bb=schema.toByteBuffer(charset);
				
		conn.runCommand(ControlerVariable.DB_CREATE,bb.array(),bb.length());
		
	}

	public  boolean commit()  throws Exception
	{
	//	int n=0;
		
		  while(true)
		  {  
			  int r=commit_once();
			  if(r==0)return true;
			  else if(r!=-1)return false;
		//	  n++;
		  	  Thread.sleep(1000);
			  //if(n>200)	return false;
		  }
		
	}
	private int commit_once()  throws Exception 
	{
		byte [] buf=conn.runCommand(ControlerVariable.COMMIT);
		if(buf==null)
			return conn.getErrCode();
		int r=VConvert.bytes2Int(buf);
		if(r==0)
		   return 0;
		return -1;
	}
	public void empty()throws Exception
	{
		for(int i=0;i<10;i++)
		{  int r=empty_once();
		
	       if(r==0)
		    	return;
	       else if(r!=-1)
	    	   break;
	       Thread.sleep(10000);
	    
		}  
		throw new Exception("can not empty db");
	}
	private int empty_once() throws Exception
	{
		byte [] buf=conn.runCommand(ControlerVariable.EMPTY);
		if(buf==null)return conn.getErrCode();
		int r=VConvert.bytes2Int(buf);
		if(r==0) return 0;
		return -1;
	}

	public boolean addDocRemote(byte[] docsBytes, int len)throws Exception 
	{
		if (len==0) return true;
		int interval=100;
		while (true)
		{
			int r=conn.addDocRemote_once(docsBytes,0,len);
			
			if(r==0)return true;
			if(r!=-1)
				return false;
			
			interval=interval<<1;
			if(interval>1000)
			{	interval=1000;
				BaseConn.log.debug("Remote Add Doc blocked ! "+conn.getIp()+":"+conn.getPort());
			}
			Thread.sleep(interval);
		}
	}
	
	public boolean addDocRemote(String table_name,byte[] docsBytes, int len)throws Exception 
	{
		if (len==0) return true;
		int interval=100;
		while (true)
		{
			int r=conn.addDocRemote_once(table_name,docsBytes,0,len);
			
			if(r==0)return true;
			if(r!=-1)
				return false;
			
			interval=interval<<1;
			if(interval>1000)
			{	interval=1000;
				BaseConn.log.debug("Remote Add Doc blocked ! "+conn.getIp()+":"+conn.getPort());
			}
			Thread.sleep(interval);
		}
	}

	public void testConnection()throws Exception  {
		conn.runCommand(ControlerVariable.CONNECTION_TEST);		
	}
	public boolean addZipedDocRemote(byte[] docsBytes, int len)throws Exception  {
		if (len==0) return true;
		
		try
		{
			byte[]  zz=GZip.compress(docsBytes, len);
			System.out.println("length:"+len+" compress to "+zz.length);
			docsBytes=zz;
			len=zz.length;
		}catch(Exception e)
		{
			e.printStackTrace();
			return true;
		}
		
		int interval=100;
		while (true)
		{
			int r=conn.addZipedDocRemote_once(docsBytes,0,len);
			
			if(r==0)return true;
			if(r!=-1)
				return false;
			
			interval=interval<<1;
			if(interval>1000)
			{	interval=1000;
				BaseConn.log.debug("Remote Add Doc blocked !");
			}
			Thread.sleep(interval);
		}
	}
	public boolean dropTable(String table_name) throws Exception {
		
		  while(true)
		  {  
			  int r=dropTable_once(table_name);
			  if(r==0)return true;
			  else if(r!=-1)return false;
		//	  n++;
		  	  Thread.sleep(1000);
			  //if(n>200)	return false;
		  }
	}
	private int dropTable_once(String table_name) throws Exception {
		ByteBuff bb=new ByteBuff();
		bb.append(table_name);
		bb.append((byte)0);
		
		byte [] buf= conn.runCommand(ControlerVariable.OPT_TABLE_DROP,bb.array(),bb.getUsed());
		if(buf==null)return conn.getErrCode();
		int r=VConvert.bytes2Int(buf);
		if(r==0) return 0;
		return -1;
	}
	public boolean createTable(String table_name) throws Exception {
		  while(true)
		  {  
			  int r=createTable_once(table_name);
			  if(r==0)return true;
			  else if(r!=-1)return false;
		//	  n++;
		  	  Thread.sleep(1000);
			  //if(n>200)	return false;
		  }
	}
	
	private int createTable_once(String table_name) throws Exception {
		ByteBuff bb=new ByteBuff();
		bb.append(table_name);
		bb.append((byte)0);
		
		byte [] buf= conn.runCommand(ControlerVariable.OPT_TABLE_CREATE,bb.array(),bb.getUsed());
		if(buf==null)return conn.getErrCode();
		int r=VConvert.bytes2Int(buf);
		if(r==0) return 0;
		return -1;
	}

	public void emptyTable(String table_name)throws Exception
	{
		for(int i=0;i<10;i++)
		{  int r=empty_table_once(table_name);
		
	       if(r==0)
		    	return;
	       else if(r!=-1)
	    	   break;
	       Thread.sleep(10000);
	    
		}  
		throw new Exception("can not empty table :"+table_name);
	}
	private int empty_table_once(String table_name) throws Exception
	{
		ByteBuff bb=new ByteBuff();
		bb.append(table_name);
		bb.append((byte)0);
		
		byte [] buf=conn.runCommand(ControlerVariable.EMPTY_TABLE,bb.array(),bb.getUsed());
		if(buf==null)return conn.getErrCode();
		int r=VConvert.bytes2Int(buf);
		if(r==0) return 0;
		return -1;
	}
	public boolean loadTable(String table_name) throws Exception {
		  while(true)
		  {  
			  int r=loadTable_once(table_name);
			  if(r==0)return true;
			  else if(r!=-1)return false;
		//	  n++;
		  	  Thread.sleep(1000);
			  //if(n>200)	return false;
		  }
	}
	
	private int loadTable_once(String table_name) throws Exception {
		ByteBuff bb=new ByteBuff();
		bb.append(table_name);
		bb.append((byte)0);
		
		byte [] buf= conn.runCommand(ControlerVariable.OPT_TABLE_LOAD,bb.array(),bb.getUsed());
		if(buf==null)return conn.getErrCode();
		int r=VConvert.bytes2Int(buf);
		if(r==0) return 0;
		return -1;
	}
	public boolean unloadTable(String table_name) throws Exception {
		  while(true)
		  {  
			  int r=unloadTable_once(table_name);
			  if(r==0)return true;
			  else if(r!=-1)return false;
		//	  n++;
		  	  Thread.sleep(1000);
			  //if(n>200)	return false;
		  }
	}
	
	private int unloadTable_once(String table_name) throws Exception {
		ByteBuff bb=new ByteBuff();
		bb.append(table_name);
		bb.append((byte)0);
		
		byte [] buf= conn.runCommand(ControlerVariable.OPT_TABLE_UNLOAD,bb.array(),bb.getUsed());
		if(buf==null)return conn.getErrCode();
		int r=VConvert.bytes2Int(buf);
		if(r==0) return 0;
		return -1;
	}
}
