package cn.sowjz.search.core.exception;

/**
 * 异常类，当执行与segment相关的操作，但是该segment又不存在，会抛出该异常
 * @author Ryan
 * @since 1.0
 * @version 1.1
 * @date 2007-4-23
 */
public class NoSegmentException extends Exception
{
	private static final long serialVersionUID = -8557095766219423569L;

	/**
	 * 构造
	 */
	public NoSegmentException()
	{
		super("There is not Segment.");
	}

	/**
	 * 构造
	 * @param msg -- 异常信息
	 */
	public NoSegmentException(String msg)
	{
		super(msg);
	}
}
