package cn.sowjz.search.core.doc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

import cn.sowjz.search.common.ByteBuff;
import cn.sowjz.search.common.VConvert;

/**
 * 负责把文章写入格式化文件
 * @author Ryan
 * @since 1.0
 * @version 1.2
 * @date 2007-4-14
 */
public class DocWriter
{
	private int cnt;

	private int i;

	private String dir;

	private String addedDir;

	private String writingDir;

	private final String format = "yyyy.MM.dd.HH.mm.ss.SSS";

	private SimpleDateFormat sdf;

	private FileOutputStream dataOut;

	private File currentFile;

	private int pos;

	private int fileMaxsize = (1 << 20) - 20;

	/**
	 * 构造
	 * @param cnt -- 每个文件写入的文章个数
	 * @param dir -- 格式化文件写好后存放的目录
	 */
	public DocWriter(int cnt, String dir, int fileMaxsize)
	{
		if (cnt > 10000)
			this.cnt = 10000;
		else if (cnt <= 0)
			this.cnt = 1;
		else
			this.cnt = cnt;
		this.dir = addPathSeparator(dir);
		sdf = new SimpleDateFormat(format);
		this.fileMaxsize = fileMaxsize;
		mkdir();
	}

	public int getFileMaxsize()
	{
		return this.fileMaxsize;
	}

	/**
	 * 创建文件全路径+文件名
	 * @return 绝对路径
	 */
	private String buildFpath()
	{
		return writingDir + sdf.format(new Date().getTime()) + ".txt";
	}

	/**
	 * 创建文件名
	 * @return 文件绝对路径
	 */
	public String buildFname()
	{
		return sdf.format(new Date().getTime()) + ".txt";
	}

	/**
	 * 打开一个文件
	 * @throws IOException
	 */
	private void open() throws IOException
	{
		String name = buildFpath();
		currentFile = new File(name);
		if (null != dataOut)
			close();
		dataOut = new FileOutputStream(currentFile);
	}

	/**
	 * 写格式化文档，把doc已规定的格式写入文件中
	 * @param doc -- 要写得doc
	 * @throws Exception
	 */
	public void write(Doc doc) throws Exception
	{
		ByteBuff buf = null;
		try
		{
			if (i == 0)
				open();
			buf = doc.toByteBuff();
		} catch (Exception ex)
		{
			ex.printStackTrace();
		}
		if(buf==null) return;
		
		if (buf.getUsed() + 4 > fileMaxsize)
		{
			System.out.println("the file size is biger than 1M , it is  "+buf.getUsed());
			return;
			/*if (pos > 0)
			{
				close();
				open();
			}
			dataOut.write(Convert.int2Bytes(fileMaxsize - 4));
			dataOut.write(buf.array(), 0, fileMaxsize - 4);
			pos += fileMaxsize;*/
		}
		if (pos + buf.getUsed() + 4 > fileMaxsize)
		{
			//System.out.println("pos + buf.getUsed() + 4 > fileMaxsize pos="+pos);
			if (pos > 0)
			{
				close();
				open();
			}
			
		} 
		{
			dataOut.write(VConvert.int2Bytes(buf.getUsed()));
			dataOut.write(buf.array(), 0, buf.getUsed());
			pos += (4 + buf.getUsed());
		}
		i++;
		if (i >= cnt)
			close();
	}

	/**
	 * 写格式化文档，把doc已规定的格式写入文件中
	 * @param docs -- 要写得doc的集合
	 * @throws Exception
	 */
	public void write(Collection<Doc> docs) throws Exception
	{
		for (Iterator<Doc> iter = docs.iterator(); iter.hasNext();)
			write(iter.next());
	}

	/**
	 * 关闭文件
	 */
	public void close()
	{
		try
		{
			if (null != dataOut)
				dataOut.close();
		} catch (Exception ex)
		{
			// ignore
		} finally
		{
			if (null != dataOut)
				dataOut = null;
		}
		i = 0;
		pos = 0;
		if (currentFile == null || !currentFile.exists())
			return;
		String newfname = dir + currentFile.getName();
		File f = new File(newfname);
		while (f.exists())
		{
			try
			{
				Thread.sleep(2);
				newfname = dir + buildFname();
				f = new File(newfname);
			} catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		}
		currentFile.renameTo(new File(newfname));
	}

	/**
	 * 添加路径分隔符
	 * @param path
	 * @return 添加文件分割符号后的文件名
	 */
	private String addPathSeparator(String path)
	{
		char c = path.charAt(path.length() - 1);
		if ('\\' != c && '/' != c)
			path += "/";
		return path;
	}

	/**
	 * 创建其它目录
	 * <ul>
	 * 在文件存放目录的位置，会生成2个目录。一个是writing，一个added。
	 * <li>writing用来存放正在写的文件。</li>
	 * <li>added用来存放加载成功的文件。 </li>
	 * </ul>
	 */
	private void mkdir()
	{
		writingDir = dir + "writing/";
		File f = new File(writingDir);
		if (!f.exists())
			f.mkdirs();
		addedDir = dir + "added/";
		f = new File(addedDir);
		if (!f.exists())
			f.mkdirs();
	}

	/**
	 * 得到加载成功的文件目录路径
	 * @return 文件目录路径
	 */
	public String getAddDirname()
	{
		return addedDir;
	}

	/**
	 * 得到正在写的文件的目录路径
	 * @return 文件目录路径
	 */
	public String getWritingDir()
	{
		return writingDir;
	}
}
