package cn.sowjz.search.core.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

import cn.sowjz.search.common.ByteBuff;
import cn.sowjz.search.common.VConvert;


public class SchemaUtil
{
    public static Schema loadFromFile(String fn)throws Exception
    {
       FileInputStream in=new FileInputStream(new File(fn));
       
       byte bb[]=new byte[16];
       in.read(bb, 0, 4);
       
       int num=VConvert.bytes2Int(bb);
       
       Schema schema=new Schema(num);
       
       for(int i=0;i<num;i++)
       {
    	   in.read(bb, 0, 16);
    	   schema.add(new FieldInfo(bb));
       }	   
       in.read(bb, 0, 4);
       int s=VConvert.bytes2Int(bb);
       schema.setSortno(s);
       in.close();
       return schema;
    }
    
    static String[] type_class_name=new String[]{"","Text","Varchar","Int32","Int64","Category","Sequence","Article","Byte16","Clob","Binary","Byte","Short","Bit","Bit2","Bit4","Kwords","CateVint","Int24","Label","Int32I"};
    
   
    public static String genCode(Schema schema){
    	StringBuffer strb=new StringBuffer();
    	
    	strb.append("\tpublic static void create_config()throws Exception	{\n\t\tSchema schema = new Schema();\n");
    	for(int i=0;i<schema.fieldNum();i++)
    	{
    		FieldInfo fi=schema.get(i);
    		String type=FieldInfo.types[fi.getType()-1]+",";
    		for(int j=type.length();j<20;j++)
    			type=type+" ";
    		strb.append("\t\tschema.add(new FieldInfo(").append(String.valueOf(i)).append(i<10?" ":"")
    			.append(", \"").append(fi.getName()).append("\", ").append("FieldInfo.").append(type);
    		
    		
    		switch(fi.getType())
    		{
    		case FieldInfo.TYPE_SEQUENCE:
    		case FieldInfo.TYPE_ARTICLE:
        			strb.append(fi.getFlag()).append(", ");break;
        			default:
        				strb.append("   ");break;
    		}
    		strb.append(fi.getWeight()).append(",").append(fi.isCached()?"true, ":"false,")
    		//.append(fi.isIndex()?"true, ":"false,").append(fi.isCompare()?"true, ":"false,")
    		.append(fi.isUnsign()?"true, ":"false,").append(fi.isTime()?"true, ":"false,")
    		.append(fi.isStore()?"true ":"false").append("));");
    		strb.append("\n");
    	}	
    	strb.append("\n\t\tschema.setSortnoByName(\"").append(schema.get(schema.getSortno()).getName()).append("\");\n");
    	strb.append("\n\t\tSchemaUtil.saveFile(schema, \"searchlib.config\");");
    	strb.append("\n\t}\n");
		return strb.toString();
    }
    public static String genCode2(Schema schema){
    	StringBuffer strb=new StringBuffer();
    	
    	strb.append("\tpublic static void create_config()throws Exception	{\n\t\tSchema schema = new Schema();\n");
    	for(int i=0;i<schema.fieldNum();i++)
    	{
    		FieldInfo fi=schema.get(i);
    		strb.append("\t\tschema.add(new FieldInfo.").append(type_class_name[fi.getType()]).append("(\"").append(fi.getName()).append("\")");
    		
    		switch(fi.getType())
    		{
    		case FieldInfo.TYPE_SEQUENCE:
    			strb.append(".external(").append(fi.getFlag()==1).append(")");break;
    		case FieldInfo.TYPE_ARTICLE:
    			strb.append(".html(").append((fi.getFlag()&2)==2).append(")");break;
    	    case FieldInfo.TYPE_BYTE16:
    			if((fi.getFlag()&1)==1)strb.append(".supportDistinct()");break;
    		}
    		strb.append(".sn(").append(String.valueOf(i)).append(")");
    		if(fi.getWeight()!=1)
    			strb.append(".weight(").append(String.valueOf(fi.getWeight())).append(")");
    		if(fi.isCached())strb.append(".cached(true)");
    		if(fi.isUnsign())strb.append(".unsign(true)");
     	//	if(fi.isIndex())strb.append(".index(true)");
     	//	if(fi.isCompare())strb.append(".compare(true)");
     		if(fi.isTime())strb.append(".time(true)");
     		if(!fi.isStore())strb.append(".store(false)");
     		
    		strb.append(");\n");
    		
    	}	
    	strb.append("\n\t\tschema.setSortnoByName(\"").append(schema.get(schema.getSortno()).getName()).append("\");\n");
    	strb.append("\n\t\tSchemaUtil.saveFile(schema, \"searchlib.config\");");
    	strb.append("\n\t}\n");
		return strb.toString();
    }
    public static void renumberSN(Schema infos){
    	int n=0;
		for (FieldInfo info : infos.getInfos())
		{	info.setSn(n++);
		}
    }
    
    public static void saveFile(Schema infos,String filename)throws Exception {
		
//		FieldInfo time_fi = infos.get(infos.getSortno());
//		if(time_fi.isInt32Field())
//			time_fi.setUnsign(true);
		
		
		for(int i=1;i<infos.fieldNum();i++)
		{
			FieldInfo fii=infos.get(i);
			for(int j=0;j<i;j++)
			{
				FieldInfo fij=infos.get(j);
				if(fii.getName().equals(fij.getName()))
					throw new Exception(fii.getName()+" used twice.");
			}	
		}	
		
		ByteBuff buf = new ByteBuff();
		// num (c:char)
		buf.append((int) infos.fieldNum());
		// info
		int n=0;
		for (FieldInfo info : infos.getInfos())
		{	info.setSn(n++);
			switch(info.getType()){
			case FieldInfo.TYPE_ARTICLE:
			case FieldInfo.TYPE_TEXT: info.setIndex(true);info.setCompare(true); break;
			case FieldInfo.TYPE_VARCHAR:
			case FieldInfo.TYPE_INT32: 
			case FieldInfo.TYPE_INT32I: 
			case FieldInfo.TYPE_INT64:
			case FieldInfo.TYPE_CATEGORY:
			case FieldInfo.TYPE_SEQUENCE:
			case FieldInfo.TYPE_LABEL:
			case FieldInfo.TYPE_BYTE16:
			case FieldInfo.TYPE_BYTE:
			case FieldInfo.TYPE_SHORT:
			case FieldInfo.TYPE_BIT:
			case FieldInfo.TYPE_BIT2:
			case FieldInfo.TYPE_BIT4:
			case FieldInfo.TYPE_KWORDS:
			case FieldInfo.TYPE_CATEVINT:
			case FieldInfo.TYPE_INT24: info.setCompare(true); info.setIndex(false);break; 
			case FieldInfo.TYPE_CLOB:
			case FieldInfo.TYPE_BINARY:info.setCompare(false); info.setIndex(false);break; 
			}
			buf.append(info.toByteBuffer("ISO-8859-1"));
		}
		// sortno(c:char)
		buf.append((int) infos.getSortno());
		
		FileOutputStream out=new FileOutputStream(new File(filename));
		
		out.write(buf.array(),0,buf.getUsed());
		out.close();
		
	}
    public static void main(String[] argv)throws Exception
    {
    	Schema f=SchemaUtil.loadFromFile("C:\\isearch\\db_t1\\searchlib.config");
    	System.out.println(genCode2(f));
    }
}
