package cn.sowjz.search.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import cn.sowjz.search.core.conf.SearchConfig;
import cn.sowjz.search.core.conf.SpecialIdxParser;
import cn.sowjz.search.core.db.Schema;
import cn.sowjz.search.core.net.control.BaseConn;
import cn.sowjz.search.core.server.state.ServerFeedInfo;

public class SearchBase {
	static protected Log log = LogFactory.getLog(SearchBase.class);

	protected Schema schema;
	public ServerFeedInfo feedinfo;
	/**
	 * 得到全文库的结构
	 * @return -- 全文库结构
	 */
	public Schema getSchema()
	{
		return schema;
	}

	
	protected SpecialIdxParser sparser; 
	public SpecialIdxParser getSpecialIdxParser() 
	{
		return sparser;
	}
	public void setSpecialIdxParser(SpecialIdxParser sparser) {
		this.sparser = sparser;
	}
	protected  SearchConfig cfg = null;
	/**
	 * 得到配置信息
	 * @return Cofiguration
	 */
	public SearchConfig getCfg()
	{
		return cfg;
	}
	public String getCharset()
	{
	    	if(feedinfo==null)
	    	{   log.error("feed info has not been  inited");
	    		return "ISO-8859-1";
	    	}
	    	return feedinfo.getCharset();
	}
	public String getFieldEnumName(String fieldName,int v)
	{
		if(sparser==null) return String.valueOf(v);
		return sparser.getEnumName(fieldName, v);
	}
	public Integer getFieldEnumId(String fieldName,String v)
	{
		if(sparser==null) return null;
		return sparser.getEnumId(fieldName, v);
	}
	public void testServerConnection(BaseConn conn) throws Exception {
	
	}
}
