package cn.sowjz.search.core;

public class ISearchException extends Exception{
	public static final int ERR_MEM_ALLOC=					1;
	public static final int ERR_MEM_ALLOC_LOCKED=			2;
	public static final int ERR_SOCKET_READ	=				3;
	public static final int ERR_SOCKET_WRITE=				4;
	public static final int ERR_NULL=						5;
	public static final int ERR_UNKNOW=						6;
	public static final int ERR_FILE_NO_FIND=				7;
	public static final int ERR_DB_NOT_EXIST=				8;				// 库不存在
	public static final int ERR_COUNT=						9;		// 统计错误
	public static final int ERR_NO_REG=						10;		// 没有seg
	public static final int ERR_FILE_IO=						11;			// io错误
	public static final int ERR_SQL_FORMAT=					12;		// SQL错误
	public static final int ERR_DEL=							13;		// 删除错误
	public static final int ERR_OPERATION_NO=				14;			// 操作请求错误
	public static final int ERR_API_VERSION_LOW=				15;
	public static final int ERR_API_WRONG=					16;
	public static final int ERR_UNSUPPORTED=					17 ;     //不支持的操作
	public static final int ERR_ARRAY_INDEX_OUTOF_BOUNDS	=18;      //数组越界
	public static final int ERR_HTTP=						19;		//http错误
	public static final int ERR_FEED_SIZE_TOO_BIG=			20; // the size of  added article is too big!";
	public static final int ERR_FEED_CANNOT_INDEX=			21;  //cannot index data any more!";
	public static final int ERR_THREAD=						22;
	public static final int ERR_THREADRUN_TIMEOUT=			23;
	public static final int ERR_DATA=						24;
	public static final int ERR_LOGIC=						25;
	public static final int ERR_LOCK_SEGMENT=				26;
	public static final int ERR_IP_BAN=						27;
	public static final int ERR_TABLE_NOT_EXIST=				28;
	public static final int ERR_STOPPED=						29;
	
	int err_code;
	public ISearchException(String text) {
		super(text);
		this.err_code=ERR_LOGIC;
	}
	public ISearchException(int err_code,String text) {
		super(text);
		this.err_code=err_code;
	}

	/**
	 * 
	 */
	private static final long serialVersionUID = 657484463509808069L;

	
	public int getErrCode(){
		return err_code;
	}
}
