/*
 * Decompiled with CFR 0.152.
 */
package cn.songxinqiang.starter.swagger;

import cn.songxinqiang.starter.swagger.SwaggerApiProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Controller;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@ConditionalOnClass(value={Controller.class})
@ConditionalOnMissingBean(value={Docket.class})
@EnableConfigurationProperties(value={SwaggerApiProperties.class})
public class SwaggerAutoConfigure {
    @Autowired
    SwaggerApiProperties properties;

    @Bean
    public Docket autoEnableSwagger() {
        return new Docket(DocumentationType.SWAGGER_2).groupName(this.properties.getName()).apiInfo(this.specialApiInfo()).select().build();
    }

    private ApiInfo specialApiInfo() {
        Contact contact = new Contact(this.properties.getContactUser(), this.properties.getContactUrl(), this.properties.getContactEmail());
        return new ApiInfoBuilder().title(this.properties.getTitle()).description(this.properties.getDescription()).contact(contact).version(this.properties.getVersion()).build();
    }
}

