/*
 * Decompiled with CFR 0.152.
 */
package cn.songxinqiang.stool.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIO {
    private static final Logger log = LoggerFactory.getLogger(FileIO.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static final List<String> readLine(File file) {
        List<String> list = null;
        try {
            list = Files.readAllLines(file.toPath());
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return list;
    }

    public static final List<String> readLine(String file) {
        return FileIO.readLine(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeFile(String file, List<String> content) {
        log.info("write file:" + file + ", content:" + Arrays.toString(content.toArray(new String[content.size()])));
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            for (String line : content) {
                writer.write(line + LINE_SEPARATOR);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeFile(String file, String content) {
        log.info("write file:" + file + ", content:" + content);
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.write(content);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
    }

    public static final LinkedHashMap<Integer, List<String>> parseFile(File file, String regex) {
        log.info("read file:" + file.getAbsolutePath() + ", with:" + regex);
        LinkedHashMap<Integer, List<String>> map = new LinkedHashMap<Integer, List<String>>();
        Iterator<String> iterator = FileIO.readLine(file).iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String[] strs = iterator.next().split(regex);
            map.put(i, Arrays.asList(strs));
            ++i;
        }
        return map;
    }
}

