/*
 * Decompiled with CFR 0.152.
 */
package cn.songxinqiang.stool.conf;

import cn.songxinqiang.stool.io.FileIO;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfFileUtil {
    private static final Logger log = LoggerFactory.getLogger(ConfFileUtil.class);
    private static final String COMMENT_LINE_START = ";";
    private static final String NODE_START = "[";
    private static final String NODE_END = "]";
    private static final String NODE_FORMAT = "[%s]";
    public static final String SEPARATOR_EQUAL = "=";
    private static final String LINE_FORMAT = "%s=%s";
    private static final Pattern LINE_SEPARATOR = Pattern.compile("=");

    public static final Map<String, Map<String, String>> readFileRecordWithNode(String file) {
        log.info("read file: " + file);
        LinkedHashMap<String, Map<String, String>> returnMap = new LinkedHashMap<String, Map<String, String>>();
        LinkedHashMap<String, String> valueMap = null;
        List<String> content = FileIO.readLine(file);
        for (String line : content) {
            if (line.length() <= 1 || line.startsWith(COMMENT_LINE_START)) continue;
            if (line.startsWith(NODE_START)) {
                valueMap = new LinkedHashMap<String, String>();
                line = line.replace(NODE_START, "").replace(NODE_END, "");
                returnMap.put(line, valueMap);
                continue;
            }
            String[] strs = LINE_SEPARATOR.split(line, -1);
            if (strs.length <= 1) {
                valueMap.put(strs[0].trim(), null);
                continue;
            }
            valueMap.put(strs[0].trim(), strs[1].trim());
        }
        log.debug("file: " + file + ", content: " + ((Object)returnMap).toString());
        return returnMap;
    }

    public static final Map<String, String> readFileRecordWithoutNode(String file) {
        log.info("read file: " + file);
        LinkedHashMap<String, String> valueMap = new LinkedHashMap<String, String>();
        List<String> content = FileIO.readLine(file);
        for (String line : content) {
            if (line.length() <= 1 || line.startsWith(COMMENT_LINE_START)) continue;
            String[] strs = LINE_SEPARATOR.split(line, -1);
            if (strs.length <= 1) {
                valueMap.put(strs[0].trim(), null);
                continue;
            }
            valueMap.put(strs[0].trim(), strs[1].trim());
        }
        log.debug("file: " + file + ", content: " + valueMap);
        return valueMap;
    }

    public static final void writeFileRecordWithNode(String file, Map<String, Map<String, String>> map) {
        log.info("write file: " + file + ", node: " + map.toString());
        LinkedList<String> contentList = new LinkedList<String>();
        for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
            String node = String.format(NODE_FORMAT, entry.getKey());
            contentList.add(node);
            Map<String, String> valueMap = entry.getValue();
            for (Map.Entry<String, String> ent : valueMap.entrySet()) {
                contentList.add(String.format(LINE_FORMAT, ent.getKey(), ent.getValue()));
            }
        }
        FileIO.writeFile(file, contentList);
    }

    public static final void writeFileRecordWithoutNode(String file, Map<String, String> map) {
        log.info("write file: " + file + ", node: " + map.toString());
        LinkedList<String> contentList = new LinkedList<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            contentList.add(String.format(LINE_FORMAT, entry.getKey(), entry.getValue()));
        }
        FileIO.writeFile(file, contentList);
    }
}

