/*
 * Decompiled with CFR 0.152.
 */
package cn.songxinqiang.stool.cmd;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemCmdExec {
    private static final Logger log = LoggerFactory.getLogger(SystemCmdExec.class);
    private static final Runtime run = Runtime.getRuntime();

    public final boolean runCmd(String cmd) {
        log.debug("run system cmd:[" + cmd + "]");
        boolean flag = false;
        try {
            run.exec(cmd);
            flag = true;
        }
        catch (Exception e) {
            log.error("run system cmd error," + e.getMessage());
            flag = false;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<String> runCmdForString(String cmd) {
        log.debug("run system cmd for String:[" + cmd + "]");
        List<String> strList = Collections.emptyList();
        BufferedInputStream in = null;
        BufferedReader inBr = null;
        try {
            Process p = run.exec(cmd);
            in = new BufferedInputStream(p.getInputStream());
            inBr = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));
            strList = inBr.lines().collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("run system cmd for String error," + e.getMessage());
        }
        finally {
            if (inBr != null) {
                try {
                    inBr.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            inBr = null;
            in = null;
        }
        return strList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<String> runCmdForString(String[] cmd) {
        log.debug("run system cmd for String:[" + Arrays.toString(cmd) + "]");
        List<String> strList = Collections.emptyList();
        BufferedInputStream in = null;
        BufferedReader inBr = null;
        try {
            Process p = run.exec(cmd);
            in = new BufferedInputStream(p.getInputStream());
            inBr = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));
            strList = inBr.lines().collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("run system cmd for String error," + e.getMessage());
        }
        finally {
            if (inBr != null) {
                try {
                    inBr.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            inBr = null;
            in = null;
        }
        return strList;
    }
}

