/*
 * Decompiled with CFR 0.152.
 */
package cn.songxinqiang.tool;

public class SharePager {
    private int totalRow;
    private int pageSize;
    private int currentPage;
    private int totalPage;
    private int startRow;

    public SharePager(int totalRow, int pageSize) {
        this.totalRow = totalRow;
        this.pageSize = pageSize < 1 ? 1 : pageSize;
        this.totalPage = (int)Math.ceil((double)totalRow / (double)pageSize);
        this.currentPage = 1;
        this.startRow = 0;
    }

    public void first() {
        this.currentPage = 1;
        this.startRow = 0;
    }

    public void previous() {
        if (this.currentPage == 1) {
            return;
        }
        --this.currentPage;
        this.startRow = (this.currentPage - 1) * this.pageSize;
    }

    public void next() {
        if (this.currentPage < this.totalPage) {
            ++this.currentPage;
        }
        this.startRow = (this.currentPage - 1) * this.pageSize;
    }

    public void last() {
        this.currentPage = this.totalPage;
        if (this.currentPage < 1) {
            this.currentPage = 1;
        }
        this.startRow = (this.currentPage - 1) * this.pageSize;
        this.totalPage = (int)Math.ceil((double)this.totalRow / (double)this.pageSize);
    }

    public void jump(int gotoPage) {
        if (gotoPage < 0) {
            this.first();
        } else if (gotoPage > this.totalPage) {
            this.last();
        } else {
            this.currentPage = gotoPage;
            this.startRow = (this.currentPage - 1) * this.pageSize;
        }
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTotalRow() {
        return this.totalRow;
    }

    public void setTotalRow(int totalRow) {
        this.totalRow = totalRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public static enum PagerAction {
        first,
        previous,
        next,
        last,
        gotoPage,
        nought;

    }
}

