/*
 * Decompiled with CFR 0.152.
 */
package cn.songxinqiang.tool;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.imageio.ImageIO;

public class RandomImage {
    private Random random = new Random();
    private Font font = new Font("Fixedsys", 1, 18);

    public ByteArrayInputStream getImage(char[] code, int width, int height, int line) {
        int i;
        BufferedImage image = new BufferedImage(width, height, 4);
        Graphics g = image.getGraphics();
        g.fillRect(0, 0, width, height);
        g.setFont(new Font("Times New Roman", 0, 18));
        g.setColor(this.getRandColor(110, 133));
        for (i = 0; i < line; ++i) {
            this.drowLine(g, width, height);
        }
        for (i = 0; i < code.length; ++i) {
            this.drowChar(g, width / code.length * i, this.random.nextInt(height / 3) + height / 3, code[i]);
        }
        g.dispose();
        return this.convertImageToStream(image);
    }

    private ByteArrayInputStream convertImageToStream(BufferedImage image) {
        ByteArrayInputStream inputStream = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "JPEG", bos);
            byte[] bts = bos.toByteArray();
            inputStream = new ByteArrayInputStream(bts);
        }
        catch (IOException e1) {
            // empty catch block
        }
        return inputStream;
    }

    private Color getRandColor(int fc, int bc) {
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + this.random.nextInt(bc - fc - 16);
        int g = fc + this.random.nextInt(bc - fc - 14);
        int b = fc + this.random.nextInt(bc - fc - 18);
        return new Color(r, g, b);
    }

    private char drowChar(Graphics g, int x, int y, char code) {
        g.setFont(this.font);
        g.setColor(this.getRandColor(10, 200));
        g.translate(this.random.nextInt(3), this.random.nextInt(3));
        g.drawString(code + "", x, y);
        return code;
    }

    private void drowLine(Graphics g, int width, int height) {
        int x = this.random.nextInt(width);
        int y = this.random.nextInt(height);
        int xl = this.random.nextInt(width / 2);
        int yl = this.random.nextInt(height / 2);
        g.drawLine(x, y, x + xl, y + yl);
    }
}

