/*
 * Decompiled with CFR 0.152.
 */
package cn.songxinqiang.tool;

import java.util.Arrays;

public class RandomCode {
    private final char[] CHAR_CODE = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public char[] getSecurityCode() {
        return this.getSecurityCode(4, SecurityCodeLevel.Medium, false);
    }

    public char[] getSecurityCode(int length, SecurityCodeLevel level, boolean isCanRepeat) {
        char[] code;
        int len = length;
        switch (level) {
            case Simple: {
                code = Arrays.copyOfRange(this.CHAR_CODE, 0, 9);
                break;
            }
            case Medium: {
                code = Arrays.copyOfRange(this.CHAR_CODE, 0, 33);
                break;
            }
            case Hard: {
                code = Arrays.copyOfRange(this.CHAR_CODE, 0, this.CHAR_CODE.length);
                break;
            }
            default: {
                code = Arrays.copyOfRange(this.CHAR_CODE, 0, this.CHAR_CODE.length);
            }
        }
        int n = code.length;
        if (len > n && !isCanRepeat) {
            throw new RuntimeException(String.format("\u8c03\u7528SecurityCode.getSecurityCode(%1$s,%2$s,%3$s)\u51fa\u73b0\u5f02\u5e38\uff0c\u5f53isCanRepeat\u4e3a%3$s\u65f6\uff0c\u4f20\u5165\u53c2\u6570%1$s\u4e0d\u80fd\u5927\u4e8e%4$s", new Object[]{len, level, isCanRepeat, n}));
        }
        char[] result = new char[len];
        if (isCanRepeat) {
            for (int i = 0; i < result.length; ++i) {
                int r = (int)(Math.random() * (double)n);
                result[i] = code[r];
            }
        } else {
            for (int i = 0; i < result.length; ++i) {
                int r = (int)(Math.random() * (double)n);
                result[i] = code[r];
                code[r] = code[n - 1];
                --n;
            }
        }
        return result;
    }

    public static enum SecurityCodeLevel {
        Simple,
        Medium,
        Hard;

    }
}

