/*
 * Decompiled with CFR 0.152.
 */
package cn.someget.cache.utils;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class RedisRepository {
    private static final Logger log = LoggerFactory.getLogger(RedisRepository.class);
    protected RedisTemplate<String, String> redisTemplate;

    @Resource(name="redisTemplate")
    public void setRedisTemplate(RedisTemplate<String, String> redisTemplate) {
        StringRedisSerializer stringSerializer = new StringRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)stringSerializer);
        redisTemplate.setValueSerializer((RedisSerializer)stringSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)stringSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)stringSerializer);
        this.redisTemplate = redisTemplate;
    }

    public void set(String key, Long expire, Object value) {
        if (value == null) {
            return;
        }
        String valueStr = value instanceof String ? value.toString() : JSON.toJSONString((Object)value);
        try {
            this.redisTemplate.opsForValue().set((Object)key, (Object)valueStr, expire.longValue(), TimeUnit.SECONDS);
            log.info("redis set, keys:[{}] value:[{}]", (Object)key, (Object)valueStr);
        }
        catch (Exception e) {
            log.warn("cache-anno redis set error, keys:[{}], values:[{}], expire:{}, msg:{}", new Object[]{key, JSON.toJSONString((Object)valueStr), expire, e.getMessage()});
        }
    }

    public void batchSet(Map<String, Object> keyValues, Long expire) {
        if (MapUtil.isEmpty(keyValues)) {
            return;
        }
        try {
            this.redisTemplate.executePipelined(connection -> {
                RedisSerializer stringSerializer = this.redisTemplate.getStringSerializer();
                keyValues.forEach((k, v) -> {
                    if (CharSequenceUtil.isBlank((CharSequence)k) || v == null) {
                        return;
                    }
                    byte[] key = stringSerializer.serialize(k);
                    byte[] value = stringSerializer.serialize((Object)(v instanceof String ? v.toString() : JSON.toJSONString((Object)v)));
                    connection.setEx(key, expire.longValue(), value);
                });
                return null;
            });
            log.info("redis batchSet, valueMap:{}", (Object)JSON.toJSONString(keyValues));
        }
        catch (Exception e) {
            log.warn("cache-anno redis batchSet error, keyValues:{}, expire:{}, msg:{}", new Object[]{JSON.toJSONString(keyValues), expire, e.getMessage()});
        }
    }

    public String get(String key) {
        try {
            String result = (String)this.redisTemplate.opsForValue().get((Object)key);
            log.info("redis get, keys:{}, result:{}", (Object)key, (Object)result);
            return result;
        }
        catch (Exception e) {
            log.error("cache-anno redis get Error, key:{}", (Object)key, (Object)e);
            return null;
        }
    }

    public Map<String, String> multiGet(List<String> keys) {
        keys = keys.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        HashMap<String, String> result = new HashMap<String, String>(keys.size());
        try {
            List redisData = this.redisTemplate.opsForValue().multiGet(keys);
            if (CollectionUtils.isEmpty((Collection)redisData)) {
                return result;
            }
            for (int i = 0; i < keys.size(); ++i) {
                String value = (String)redisData.get(i);
                String key = keys.get(i);
                if (CharSequenceUtil.isBlank((CharSequence)key)) continue;
                result.put(key, value);
            }
            log.info("redis multiGet, keys:{}, result:{}", (Object)JSON.toJSONString(keys), (Object)JSON.toJSONString(result));
        }
        catch (Exception e) {
            log.error("cache-anno redis multiGet Error, keys:{}, msg:{}", (Object)JSON.toJSONString(keys), (Object)e.getMessage());
        }
        return result;
    }
}

