/*
 * Decompiled with CFR 0.152.
 */
package cn.someget.cache.utils;

import cn.hutool.core.map.MapUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class LocalCache {
    private static final Logger log = LoggerFactory.getLogger(LocalCache.class);
    private Cache<String, Object> cache;

    @PostConstruct
    public void buildCache() {
        this.cache = Caffeine.newBuilder().recordStats().removalListener((key, value, cause) -> log.info("key:{}, was removed, cause:{}", key, (Object)cause)).expireAfterWrite(3L, TimeUnit.SECONDS).build();
    }

    public Object getIfPresent(String key) {
        return this.cache.getIfPresent((Object)key);
    }

    public Map<String, Object> getAllPresent(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptyMap();
        }
        return this.cache.getAllPresent(keys);
    }

    public void delete(String key) {
        this.cache.invalidate((Object)key);
    }

    public void put(String key, Object object) {
        this.cache.put((Object)key, object);
    }

    public void putAll(Map<String, Object> caches) {
        if (MapUtil.isEmpty(caches)) {
            return;
        }
        this.cache.putAll(caches);
    }

    @Scheduled(fixedDelay=60000L)
    public void stats() {
        CacheStats stats = this.cache.stats();
        log.info("local cache stats, missCount:{}, missRate:{}, hitCount:{}, hitRate:{}", new Object[]{stats.missCount(), stats.missRate(), stats.hitCount(), stats.hitRate()});
    }
}

